/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.guice.DruidBinders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.MapQueryToolChestWarehouse;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCache;
import org.apache.druid.segment.metadata.SegmentMetadataQuerySegmentWalker;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QuerySchedulerProvider;

public class SegmentSchemaCacheModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.segmentMetadata", SegmentMetadataQueryConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.query.scheduler", QuerySchedulerProvider.class, Global.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.query.default", DefaultQueryConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.query.retryPolicy", RetryQueryRunnerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.internal.query.config", InternalQueryConfig.class);
        MapBinder toolChests = DruidBinders.queryToolChestBinder((Binder)binder);
        toolChests.addBinding(SegmentMetadataQuery.class).to(SegmentMetadataQueryQueryToolChest.class);
        binder.bind(SegmentMetadataQueryQueryToolChest.class).in(LazySingleton.class);
        binder.bind(QueryToolChestWarehouse.class).to(MapQueryToolChestWarehouse.class);
        MapBinder queryFactoryBinder = DruidBinders.queryRunnerFactoryBinder((Binder)binder);
        queryFactoryBinder.addBinding(SegmentMetadataQuery.class).to(SegmentMetadataQueryRunnerFactory.class);
        DruidBinders.queryBinder((Binder)binder);
        binder.bind(SegmentMetadataQueryRunnerFactory.class).in(LazySingleton.class);
        binder.bind(GenericQueryMetricsFactory.class).to(DefaultGenericQueryMetricsFactory.class);
        binder.bind(QueryScheduler.class).toProvider(Key.get(QuerySchedulerProvider.class, Global.class)).in(LazySingleton.class);
        binder.bind(QuerySchedulerProvider.class).in(LazySingleton.class);
        binder.bind(QuerySegmentWalker.class).to(SegmentMetadataQuerySegmentWalker.class).in(LazySingleton.class);
        LifecycleModule.register((Binder)binder, CoordinatorSegmentMetadataCache.class);
    }

    @LazySingleton
    @Provides
    public QueryWatcher getWatcher(QueryScheduler scheduler) {
        return scheduler;
    }
}

