/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.cli.Main;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.StandardURLClassLoader;
import org.apache.druid.indexer.HadoopTaskConfig;
import org.apache.druid.indexing.common.task.Initialization;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.JvmUtils;

@Command(name="hadoop", description="Runs the batch Hadoop Druid Indexer, see https://druid.apache.org/docs/latest/Batch-ingestion.html for a description.")
public class CliHadoopIndexer
implements Runnable {
    private static final List<String> DEFAULT_HADOOP_COORDINATES = HadoopTaskConfig.DEFAULT_DEFAULT_HADOOP_COORDINATES;
    private static final Logger log = new Logger(CliHadoopIndexer.class);
    @Arguments(description="A JSON object or the path to a file that contains a JSON object")
    @Required
    private String argumentSpec;
    @Option(name={"-c", "--coordinate", "hadoopDependencies"}, description="extra dependencies to pull down (e.g. non-default hadoop coordinates or extra hadoop jars)")
    private List<String> coordinates;
    @Option(name={"--no-default-hadoop"}, description="don't pull down the default hadoop version")
    public boolean noDefaultHadoop;
    @Inject
    private ExtensionsLoader extnLoader;

    @Override
    public void run() {
        try {
            ArrayList<String> allCoordinates = new ArrayList<String>();
            if (this.coordinates != null) {
                allCoordinates.addAll(this.coordinates);
            }
            if (!this.noDefaultHadoop) {
                allCoordinates.addAll(DEFAULT_HADOOP_COORDINATES);
            }
            ArrayList<URL> extensionURLs = new ArrayList<URL>();
            for (File extension : this.extnLoader.getExtensionFilesToLoad()) {
                StandardURLClassLoader extensionLoader = this.extnLoader.getClassLoaderForExtension(extension, false);
                extensionURLs.addAll(Arrays.asList(extensionLoader.getURLs()));
            }
            List nonHadoopURLs = JvmUtils.systemClassPath();
            ArrayList<URL> driverURLs = new ArrayList<URL>(nonHadoopURLs);
            for (File hadoopDependency : Initialization.getHadoopDependencyFilesToLoad(allCoordinates, (ExtensionsConfig)this.extnLoader.config())) {
                StandardURLClassLoader hadoopLoader = this.extnLoader.getClassLoaderForExtension(hadoopDependency, false);
                driverURLs.addAll(Arrays.asList(hadoopLoader.getURLs()));
            }
            URLClassLoader loader = new URLClassLoader(driverURLs.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
            ArrayList<URL> jobUrls = new ArrayList<URL>();
            jobUrls.addAll(nonHadoopURLs);
            jobUrls.addAll(extensionURLs);
            System.setProperty("druid.hadoop.internal.classpath", Joiner.on((String)File.pathSeparator).join(jobUrls));
            Class<?> mainClass = loader.loadClass(Main.class.getName());
            Method mainMethod = mainClass.getMethod("main", String[].class);
            String[] args = new String[]{"internal", "hadoop-indexer", this.argumentSpec};
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            log.error((Throwable)e, "failure!!!!", new Object[0]);
            System.exit(1);
        }
    }
}

