/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.input;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableInputStreamFrameChannel;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.shuffle.input.DurableStorageQueryResultsInputChannelFactory;
import org.apache.druid.msq.shuffle.input.DurableStorageStageInputChannelFactory;
import org.apache.druid.storage.StorageConnector;

public abstract class DurableStorageInputChannelFactory
implements InputChannelFactory {
    private static final Logger LOG = new Logger(DurableStorageInputChannelFactory.class);
    private final StorageConnector storageConnector;
    private final ExecutorService remoteInputStreamPool;
    private final String controllerTaskId;

    public DurableStorageInputChannelFactory(String controllerTaskId, StorageConnector storageConnector, ExecutorService remoteInputStreamPool) {
        this.controllerTaskId = (String)Preconditions.checkNotNull((Object)controllerTaskId, (Object)"controllerTaskId");
        this.storageConnector = (StorageConnector)Preconditions.checkNotNull((Object)storageConnector, (Object)"storageConnector");
        this.remoteInputStreamPool = (ExecutorService)Preconditions.checkNotNull((Object)remoteInputStreamPool, (Object)"remoteInputStreamPool");
    }

    public static DurableStorageInputChannelFactory createStandardImplementation(String controllerTaskId, StorageConnector storageConnector, Closer closer, boolean isQueryResults) {
        String threadNameFormat = StringUtils.encodeForFormat((String)((String)Preconditions.checkNotNull((Object)controllerTaskId, (Object)"controllerTaskId"))) + "-remote-fetcher-%d";
        ExecutorService remoteInputStreamPool = Executors.newCachedThreadPool(Execs.makeThreadFactory((String)threadNameFormat));
        closer.register(remoteInputStreamPool::shutdownNow);
        if (isQueryResults) {
            return new DurableStorageQueryResultsInputChannelFactory(controllerTaskId, storageConnector, remoteInputStreamPool);
        }
        return new DurableStorageStageInputChannelFactory(controllerTaskId, storageConnector, remoteInputStreamPool);
    }

    @Override
    public ReadableFrameChannel openChannel(StageId stageId, int workerNumber, int partitionNumber) throws IOException {
        try {
            String remotePartitionPath = this.findSuccessfulPartitionOutput(this.controllerTaskId, workerNumber, stageId.getStageNumber(), partitionNumber);
            LOG.debug("Reading output of stage [%d], partition [%d] for worker [%d] from the file at path [%s]", new Object[]{stageId.getStageNumber(), partitionNumber, workerNumber, remotePartitionPath});
            if (!this.storageConnector.pathExists(remotePartitionPath)) {
                throw new ISE("Could not find remote outputs of stage [%d] partition [%d] for worker [%d] at the path [%s]", new Object[]{stageId.getStageNumber(), partitionNumber, workerNumber, remotePartitionPath});
            }
            InputStream inputStream = this.storageConnector.read(remotePartitionPath);
            return ReadableInputStreamFrameChannel.open((InputStream)inputStream, (String)remotePartitionPath, (ExecutorService)this.remoteInputStreamPool, (boolean)false);
        }
        catch (Exception e) {
            throw new IOE((Throwable)e, "Encountered error while reading the output of stage [%d], partition [%d] for worker [%d]", new Object[]{stageId.getStageNumber(), partitionNumber, workerNumber});
        }
    }

    public String findSuccessfulPartitionOutput(String controllerTaskId, int workerNo, int stageNumber, int partitionNumber) throws IOException {
        String successfulTaskId;
        String successfulFilePath = this.getWorkerOutputSuccessFilePath(controllerTaskId, stageNumber, workerNo);
        if (!this.storageConnector.pathExists(successfulFilePath)) {
            throw new ISE("No file present at the location [%s]. Unable to read the outputs of stage [%d], partition [%d] for the worker [%d]", new Object[]{successfulFilePath, stageNumber, partitionNumber, workerNo});
        }
        try (InputStream is = this.storageConnector.read(successfulFilePath);){
            successfulTaskId = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        if (successfulTaskId == null) {
            throw new ISE("Unable to read the task id from the file: [%s]", new Object[]{successfulFilePath});
        }
        LOG.debug("Reading output of stage [%d], partition [%d] from task id [%s]", new Object[]{stageNumber, partitionNumber, successfulTaskId});
        return this.getPartitionOutputsFileNameWithPathForPartition(controllerTaskId, stageNumber, workerNo, partitionNumber, successfulTaskId);
    }

    public abstract String getPartitionOutputsFileNameWithPathForPartition(String var1, int var2, int var3, int var4, String var5);

    public abstract String getWorkerOutputSuccessFilePath(String var1, int var2, int var3);
}

