/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical.stages;

import java.util.Collections;
import org.apache.calcite.rel.core.Project;
import org.apache.druid.msq.exec.StageProcessor;
import org.apache.druid.msq.logical.StageMaker;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.msq.logical.stages.ProjectStage;
import org.apache.druid.msq.logical.stages.ReadStage;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.DruidQueryGenerator;
import org.apache.druid.sql.calcite.rel.Projection;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.rel.logical.DruidAggregate;
import org.apache.druid.sql.calcite.rel.logical.DruidProject;

class FilterStage
extends ReadStage {
    protected final VirtualColumnRegistry virtualColumnRegistry;
    protected final DimFilter dimFilter;

    public FilterStage(ReadStage inputStage, VirtualColumnRegistry virtualColumnRegistry, DimFilter dimFilter) {
        super(inputStage, inputStage.signature);
        this.virtualColumnRegistry = virtualColumnRegistry;
        this.dimFilter = dimFilter;
    }

    protected FilterStage(FilterStage stage, VirtualColumnRegistry newVirtualColumnRegistry, RowSignature rowSignature) {
        super(stage, rowSignature);
        this.dimFilter = stage.dimFilter;
        this.virtualColumnRegistry = newVirtualColumnRegistry;
    }

    @Override
    public LogicalStage extendWith(DruidQueryGenerator.DruidNodeStack stack) {
        if (stack.getNode() instanceof DruidProject) {
            DruidProject project = (DruidProject)stack.getNode();
            Projection projection = Projection.preAggregation((Project)project, (PlannerContext)stack.getPlannerContext(), (RowSignature)this.signature, (VirtualColumnRegistry)this.virtualColumnRegistry);
            return new ProjectStage(this, this.virtualColumnRegistry, projection.getOutputRowSignature());
        }
        if (stack.getNode() instanceof DruidAggregate) {
            return new ProjectStage(this, this.virtualColumnRegistry, this.signature).extendWith(stack);
        }
        return null;
    }

    @Override
    public StageProcessor<?, ?> buildStageProcessor(StageMaker stageMaker) {
        VirtualColumns virtualColumns = this.virtualColumnRegistry.build(Collections.emptySet());
        return StageMaker.makeScanStageProcessor(virtualColumns, this.signature, this.dimFilter);
    }

    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    public VirtualColumns getVirtualColumns() {
        return this.virtualColumnRegistry.build(Collections.emptySet());
    }
}

