/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.jackson.CommaListJoinDeserializer;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;

public class DataSegmentWithLocation
extends DataSegment {
    private final Set<DruidServerMetadata> servers;

    @JsonCreator
    private DataSegmentWithLocation(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") String interval, @JsonProperty(value="version") String version, @JsonProperty(value="loadSpec") @Nullable Map<String, Object> loadSpec, @JsonProperty(value="dimensions") @JsonDeserialize(using=CommaListJoinDeserializer.class) @Nullable List<String> dimensions, @JsonProperty(value="metrics") @JsonDeserialize(using=CommaListJoinDeserializer.class) @Nullable List<String> metrics, @JsonProperty(value="projections") @JsonDeserialize(using=CommaListJoinDeserializer.class) @Nullable List<String> projections, @JsonProperty(value="shardSpec") @Nullable ShardSpec shardSpec, @JsonProperty(value="lastCompactionState") @Nullable CompactionState lastCompactionState, @JsonProperty(value="binaryVersion") Integer binaryVersion, @JsonProperty(value="size") long size, @JsonProperty(value="servers") Set<DruidServerMetadata> servers, @JacksonInject DataSegment.PruneSpecsHolder pruneSpecsHolder) {
        super(dataSource, Intervals.fromString((String)interval), version, loadSpec, dimensions, metrics, projections, shardSpec, lastCompactionState, binaryVersion, size, pruneSpecsHolder);
        this.servers = (Set)Preconditions.checkNotNull(servers, (Object)"servers");
    }

    public DataSegmentWithLocation(DataSegment dataSegment, Set<DruidServerMetadata> servers) {
        super(dataSegment.getDataSource(), dataSegment.getInterval(), dataSegment.getVersion(), dataSegment.getLoadSpec(), dataSegment.getDimensions(), dataSegment.getMetrics(), dataSegment.getProjections(), dataSegment.getShardSpec(), null, dataSegment.getBinaryVersion(), dataSegment.getSize(), DataSegment.PruneSpecsHolder.DEFAULT);
        this.servers = servers;
    }

    @JsonProperty(value="servers")
    public Set<DruidServerMetadata> getServers() {
        return this.servers;
    }
}

