/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.msq.indexing.error.BaseMSQFault;
import org.apache.druid.msq.indexing.error.CancellationReason;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;

@JsonTypeName(value="Canceled")
public class CanceledFault
extends BaseMSQFault {
    public static final String CODE = "Canceled";
    private final CancellationReason reason;

    @JsonCreator
    public CanceledFault(@JsonProperty(value="reason") @Nullable CancellationReason reason) {
        super(CODE, "Query canceled due to [%s].", (Object)(reason == null ? CancellationReason.UNKNOWN : reason), new Object[0]);
        this.reason = reason == null ? CancellationReason.UNKNOWN : reason;
    }

    public static CanceledFault userRequest() {
        return new CanceledFault(CancellationReason.USER_REQUEST);
    }

    public static CanceledFault shutdown() {
        return new CanceledFault(CancellationReason.TASK_SHUTDOWN);
    }

    public static CanceledFault timeout() {
        return new CanceledFault(CancellationReason.QUERY_TIMEOUT);
    }

    public static CanceledFault unknown() {
        return new CanceledFault(CancellationReason.UNKNOWN);
    }

    @JsonProperty
    public CancellationReason getReason() {
        return this.reason;
    }

    @Override
    public DruidException toDruidException() {
        return DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.CANCELED).withErrorCode(this.getErrorCode()).build(MSQFaultUtils.generateMessageWithErrorCode(this), new Object[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CanceledFault that = (CanceledFault)o;
        return this.reason == that.reason;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.reason});
    }
}

