/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.calcite.planner.ColumnMappings;

public class LegacyMSQSpec
extends MSQSpec {
    private final Query<?> query;

    public LegacyMSQSpec() {
        this.query = null;
    }

    public LegacyMSQSpec(@JsonProperty(value="query") Query<?> query, @JsonProperty(value="columnMappings") ColumnMappings columnMappings, @JsonProperty(value="destination") MSQDestination destination, @JsonProperty(value="assignmentStrategy") WorkerAssignmentStrategy assignmentStrategy, @JsonProperty(value="tuningConfig") MSQTuningConfig tuningConfig) {
        super(columnMappings, destination, assignmentStrategy, tuningConfig);
        this.query = (Query)Preconditions.checkNotNull(query, (Object)"query");
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty
    public Query<?> getQuery() {
        return this.query;
    }

    @Override
    public String getId() {
        return this.getContext().getString("queryId");
    }

    @Override
    public QueryContext getContext() {
        return QueryContext.of((Map)this.query.getContext());
    }

    public LegacyMSQSpec withOverriddenContext(Map<String, Object> contextOverride) {
        if (contextOverride == null || contextOverride.isEmpty()) {
            return this;
        }
        return new LegacyMSQSpec(this.query.withOverriddenContext(contextOverride), this.getColumnMappings(), this.getDestination(), this.getAssignmentStrategy(), this.getTuningConfig());
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LegacyMSQSpec that = (LegacyMSQSpec)o;
        return Objects.equals(this.query, that.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query);
    }

    public static class Builder {
        private Query<?> query;
        private ColumnMappings columnMappings;
        private MSQDestination destination = TaskReportMSQDestination.instance();
        private WorkerAssignmentStrategy assignmentStrategy = WorkerAssignmentStrategy.MAX;
        private MSQTuningConfig tuningConfig;
        private QueryContext queryContext = QueryContext.empty();

        public Builder query(Query<?> query) {
            this.query = query;
            return this;
        }

        public Builder columnMappings(ColumnMappings columnMappings) {
            this.columnMappings = columnMappings;
            return this;
        }

        public Builder destination(MSQDestination destination) {
            this.destination = destination;
            return this;
        }

        public Builder assignmentStrategy(WorkerAssignmentStrategy assignmentStrategy) {
            this.assignmentStrategy = assignmentStrategy;
            return this;
        }

        public Builder tuningConfig(MSQTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        public LegacyMSQSpec build() {
            if (this.destination == null) {
                this.destination = TaskReportMSQDestination.instance();
            }
            return new LegacyMSQSpec(this.query.withOverriddenContext(this.queryContext.asMap()), this.columnMappings, this.destination, this.assignmentStrategy, this.tuningConfig);
        }

        public Builder queryContext(QueryContext queryContext) {
            this.queryContext = queryContext;
            return this;
        }
    }
}

