/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.SegmentSource;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.SlicerUtils;
import org.apache.druid.msq.input.table.DataSegmentWithLocation;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;
import org.apache.druid.msq.input.table.DataServerSelector;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.Interval;

public class IndexerTableInputSpecSlicer
implements InputSpecSlicer {
    private static final Logger log = new Logger(IndexerTableInputSpecSlicer.class);
    private final CoordinatorClient coordinatorClient;
    private final TaskActionClient taskActionClient;
    private final SegmentSource includeSegmentSource;

    public IndexerTableInputSpecSlicer(CoordinatorClient coordinatorClient, TaskActionClient taskActionClient, SegmentSource includeSegmentSource) {
        this.coordinatorClient = coordinatorClient;
        this.taskActionClient = taskActionClient;
        this.includeSegmentSource = includeSegmentSource;
    }

    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return true;
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        TableInputSpec tableInputSpec = (TableInputSpec)inputSpec;
        ArrayList<DataSegmentWithInterval> prunedPublishedSegments = new ArrayList<DataSegmentWithInterval>();
        ArrayList<DataSegmentWithInterval> prunedServedSegments = new ArrayList<DataSegmentWithInterval>();
        for (DataSegmentWithInterval dataSegmentWithInterval : this.getPrunedSegmentSet(tableInputSpec)) {
            if (dataSegmentWithInterval.segment instanceof DataSegmentWithLocation) {
                prunedServedSegments.add(dataSegmentWithInterval);
                continue;
            }
            prunedPublishedSegments.add(dataSegmentWithInterval);
        }
        List<WeightedInputInstance> groupedServedSegments = IndexerTableInputSpecSlicer.createWeightedSegmentSet(prunedServedSegments);
        List<List<WeightedInputInstance>> assignments = SlicerUtils.makeSlicesStatic(Iterators.concat(groupedServedSegments.iterator(), prunedPublishedSegments.iterator()), WeightedInputInstance::getWeight, maxNumSlices);
        return IndexerTableInputSpecSlicer.makeSlices(tableInputSpec, assignments);
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        TableInputSpec tableInputSpec = (TableInputSpec)inputSpec;
        ArrayList<WeightedInputInstance> prunedSegments = new ArrayList<WeightedInputInstance>();
        ArrayList<DataSegmentWithInterval> prunedServedSegments = new ArrayList<DataSegmentWithInterval>();
        for (DataSegmentWithInterval dataSegmentWithInterval : this.getPrunedSegmentSet(tableInputSpec)) {
            if (dataSegmentWithInterval.segment instanceof DataSegmentWithLocation) {
                prunedServedSegments.add(dataSegmentWithInterval);
                continue;
            }
            prunedSegments.add(dataSegmentWithInterval);
        }
        List<WeightedInputInstance> groupedServedSegments = IndexerTableInputSpecSlicer.createWeightedSegmentSet(prunedServedSegments);
        prunedSegments.addAll(groupedServedSegments);
        List<List<WeightedInputInstance>> assignments = SlicerUtils.makeSlicesDynamic(prunedSegments.iterator(), WeightedInputInstance::getWeight, maxNumSlices, maxFilesPerSlice, maxBytesPerSlice);
        return IndexerTableInputSpecSlicer.makeSlices(tableInputSpec, assignments);
    }

    private Set<DataSegmentWithInterval> getPrunedSegmentSet(TableInputSpec tableInputSpec) {
        VersionedIntervalTimeline<String, DataSegment> timeline = this.getTimeline(tableInputSpec.getDataSource(), tableInputSpec.getIntervals());
        if (timeline == null) {
            return Collections.emptySet();
        }
        Iterator dataSegmentIterator = tableInputSpec.getIntervals().stream().flatMap(interval -> timeline.lookup(interval).stream()).flatMap(holder -> StreamSupport.stream(holder.getObject().spliterator(), false).filter(chunk -> !((DataSegment)chunk.getObject()).isTombstone()).map(chunk -> new DataSegmentWithInterval((DataSegment)chunk.getObject(), holder.getInterval()))).iterator();
        return DimFilterUtils.filterShards((DimFilter)tableInputSpec.getFilter(), tableInputSpec.getFilterFields(), () -> dataSegmentIterator, segment -> segment.getSegment().getShardSpec(), new HashMap());
    }

    @Nullable
    private VersionedIntervalTimeline<String, DataSegment> getTimeline(String dataSource, List<Interval> intervals) {
        Collection<Object> publishedUsedSegments;
        boolean includeRealtime = SegmentSource.shouldQueryRealtimeServers(this.includeSegmentSource);
        Iterable realtimeAndHistoricalSegments = includeRealtime ? this.coordinatorClient.fetchServerViewSegments(dataSource, intervals) : ImmutableList.of();
        try {
            publishedUsedSegments = intervals.isEmpty() ? Collections.emptySet() : (Collection)this.taskActionClient.submit((TaskAction)new RetrieveUsedSegmentsAction(dataSource, intervals));
        }
        catch (IOException e) {
            throw new MSQException(e, UnknownFault.forException(e));
        }
        int realtimeCount = 0;
        HashSet unifiedSegmentView = new HashSet(publishedUsedSegments);
        Iterator iterator = realtimeAndHistoricalSegments.iterator();
        while (iterator.hasNext()) {
            ImmutableSegmentLoadInfo segmentLoadInfo = (ImmutableSegmentLoadInfo)iterator.next();
            ImmutableSet servers = segmentLoadInfo.getServers();
            Set<DruidServerMetadata> realtimeServerMetadata = servers.stream().filter(druidServerMetadata -> this.includeSegmentSource.getUsedServerTypes().contains(druidServerMetadata.getType())).collect(Collectors.toSet());
            if (realtimeServerMetadata.isEmpty()) continue;
            ++realtimeCount;
            DataSegmentWithLocation dataSegmentWithLocation = new DataSegmentWithLocation(segmentLoadInfo.getSegment(), realtimeServerMetadata);
            unifiedSegmentView.add(dataSegmentWithLocation);
        }
        if (includeRealtime) {
            log.info("Fetched total [%d] segments from coordinator: [%d] from metadata stoure, [%d] from server view", new Object[]{unifiedSegmentView.size(), publishedUsedSegments.size(), realtimeCount});
        }
        if (unifiedSegmentView.isEmpty()) {
            return null;
        }
        return SegmentTimeline.forSegments(unifiedSegmentView);
    }

    private static List<InputSlice> makeSlices(TableInputSpec tableInputSpec, List<List<WeightedInputInstance>> assignments) {
        ArrayList<InputSlice> retVal = new ArrayList<InputSlice>(assignments.size());
        for (List<WeightedInputInstance> assignment : assignments) {
            ArrayList<RichSegmentDescriptor> descriptors = new ArrayList<RichSegmentDescriptor>();
            ArrayList<DataServerRequestDescriptor> dataServerRequests = new ArrayList<DataServerRequestDescriptor>();
            for (WeightedInputInstance weightedSegment : assignment) {
                if (weightedSegment instanceof DataSegmentWithInterval) {
                    DataSegmentWithInterval dataSegmentWithInterval = (DataSegmentWithInterval)weightedSegment;
                    descriptors.add(dataSegmentWithInterval.toRichSegmentDescriptor());
                    continue;
                }
                DataServerRequest serverRequest = (DataServerRequest)weightedSegment;
                dataServerRequests.add(serverRequest.toDataServerRequestDescriptor());
            }
            if (descriptors.isEmpty() && dataServerRequests.isEmpty()) {
                retVal.add(NilInputSlice.INSTANCE);
                continue;
            }
            retVal.add(new SegmentsInputSlice(tableInputSpec.getDataSource(), descriptors, dataServerRequests));
        }
        return retVal;
    }

    private static List<WeightedInputInstance> createWeightedSegmentSet(List<DataSegmentWithInterval> prunedServedSegments) {
        HashMap<DruidServerMetadata, Set> serverVsSegmentsMap = new HashMap<DruidServerMetadata, Set>();
        for (DataSegmentWithInterval dataSegmentWithInterval : prunedServedSegments) {
            DataSegmentWithLocation segmentWithLocation = (DataSegmentWithLocation)dataSegmentWithInterval.segment;
            DruidServerMetadata druidServerMetadata = DataServerSelector.RANDOM.getSelectServerFunction().apply(segmentWithLocation.getServers());
            serverVsSegmentsMap.computeIfAbsent(druidServerMetadata, ignored -> new HashSet());
            ((Set)serverVsSegmentsMap.get(druidServerMetadata)).add(dataSegmentWithInterval);
        }
        ArrayList<WeightedInputInstance> retVal = new ArrayList<WeightedInputInstance>();
        for (Map.Entry druidServerMetadataSetEntry : serverVsSegmentsMap.entrySet()) {
            DataServerRequest dataServerRequest = new DataServerRequest((DruidServerMetadata)druidServerMetadataSetEntry.getKey(), (List<DataSegmentWithInterval>)ImmutableList.copyOf((Collection)((Collection)druidServerMetadataSetEntry.getValue())));
            retVal.add(dataServerRequest);
        }
        return retVal;
    }

    private static class DataSegmentWithInterval
    implements WeightedInputInstance {
        private final DataSegment segment;
        private final Interval interval;

        public DataSegmentWithInterval(DataSegment segment, Interval interval) {
            this.segment = (DataSegment)Preconditions.checkNotNull((Object)segment, (Object)"segment");
            this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        }

        public DataSegment getSegment() {
            return this.segment;
        }

        public RichSegmentDescriptor toRichSegmentDescriptor() {
            return new RichSegmentDescriptor(this.segment.getInterval(), this.interval, this.segment.getVersion(), this.segment.getShardSpec().getPartitionNum());
        }

        @Override
        public long getWeight() {
            return this.segment.getSize();
        }
    }

    private static interface WeightedInputInstance {
        public long getWeight();
    }

    private static class DataServerRequest
    implements WeightedInputInstance {
        private static final long DATA_SERVER_WEIGHT_ESTIMATION = 5000L;
        private final List<DataSegmentWithInterval> segments;
        private final DruidServerMetadata serverMetadata;

        public DataServerRequest(DruidServerMetadata serverMetadata, List<DataSegmentWithInterval> segments) {
            this.segments = (List)Preconditions.checkNotNull(segments, (Object)"segments");
            this.serverMetadata = (DruidServerMetadata)Preconditions.checkNotNull((Object)serverMetadata, (Object)"server");
        }

        @Override
        public long getWeight() {
            return (long)this.segments.size() * 5000L;
        }

        public DataServerRequestDescriptor toDataServerRequestDescriptor() {
            return new DataServerRequestDescriptor(this.serverMetadata, this.segments.stream().map(DataSegmentWithInterval::toRichSegmentDescriptor).collect(Collectors.toList()));
        }
    }
}

