/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.exec.ProcessingBuffersSet;

public class IndexerProcessingBuffersProvider
implements ProcessingBuffersProvider {
    private static final int MIN_BUFFER_SIZE = 1000000;
    private final long heapMemoryToUse;
    private final int taskCapacity;
    private final int numThreads;

    public IndexerProcessingBuffersProvider(long heapMemoryToUse, int taskCapacity, int numThreads) {
        this.heapMemoryToUse = heapMemoryToUse;
        this.taskCapacity = taskCapacity;
        this.numThreads = numThreads;
    }

    @Override
    public ResourceHolder<ProcessingBuffersSet> acquire(int poolSize, long timeoutMillis) {
        if (poolSize == 0) {
            return new ReferenceCountingResourceHolder((Object)ProcessingBuffersSet.EMPTY, () -> {});
        }
        long heapMemoryPerWorker = this.heapMemoryToUse / (long)this.taskCapacity;
        int numThreadsPerWorker = (int)Math.min((long)this.numThreads, heapMemoryPerWorker / 1000000L);
        if (numThreadsPerWorker < 1) {
            throw new ISE("Cannot acquire buffers, available heap memory is not enough for task capacity[%d]", new Object[]{this.taskCapacity});
        }
        ArrayList bufferPools = new ArrayList(poolSize);
        int sliceSize = (int)Math.min(Integer.MAX_VALUE, heapMemoryPerWorker / (long)numThreadsPerWorker);
        for (int i = 0; i < poolSize; ++i) {
            ArrayList<ByteBuffer> bufferPool = new ArrayList<ByteBuffer>(numThreadsPerWorker);
            bufferPools.add(bufferPool);
            for (int j = 0; j < numThreadsPerWorker; ++j) {
                bufferPool.add(ByteBuffer.allocate(sliceSize));
            }
        }
        return new ReferenceCountingResourceHolder((Object)ProcessingBuffersSet.fromCollection(bufferPools), () -> {});
    }
}

