/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.QueryContext;

public class MSQMetriceEventBuilder
extends ServiceMetricEvent.Builder {
    private static final String QUERY_METRIC_TYPE = "msq";

    public void setDartDimensions(QueryContext queryContext) {
        this.setQueryIdDimensions(queryContext);
        this.setDimension("engine", "msq-dart");
    }

    public void setTaskDimensions(Task task, QueryContext queryContext) {
        this.setQueryIdDimensions(queryContext);
        this.setDimension("taskId", task.getId());
        this.setDimension("taskType", task.getType());
        if (this.getDimension("dataSource") == null) {
            this.setDimension("dataSource", task.getDataSource());
        }
        this.setDimensionIfNotNull("tags", task.getContextValue("tags"));
        this.setDimensionIfNotNull("groupId", task.getGroupId());
        this.setDimension("engine", "msq-task");
    }

    private void setQueryIdDimensions(QueryContext queryContext) {
        this.setDimensionIfNotNull("queryId", queryContext.getString("queryId"));
        this.setDimensionIfNotNull("sqlQueryId", queryContext.getString("sqlQueryId"));
        this.setDimension("type", QUERY_METRIC_TYPE);
    }
}

