/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.base.Preconditions;
import org.apache.druid.frame.FrameType;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;

public class FrameWriterSpec {
    private final FrameType rowBasedFrameType;
    private final boolean removeNullBytes;

    public FrameWriterSpec(FrameType rowBasedFrameType, boolean removeNullBytes) {
        this.rowBasedFrameType = (FrameType)Preconditions.checkNotNull((Object)rowBasedFrameType, (Object)"rowBasedFrameType");
        this.removeNullBytes = removeNullBytes;
    }

    public static FrameWriterSpec fromContext(QueryContext queryContext) {
        return new FrameWriterSpec(MultiStageQueryContext.getRowBasedFrameType(queryContext), MultiStageQueryContext.removeNullBytes(queryContext));
    }

    public FrameType getRowBasedFrameType() {
        return this.rowBasedFrameType;
    }

    public boolean getRemoveNullBytes() {
        return this.removeNullBytes;
    }
}

