/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.sql;

import java.util.List;
import java.util.Map;
import org.apache.druid.msq.dart.controller.sql.DartQueryMaker;
import org.apache.druid.msq.exec.QueryKitBasedMSQPlanner;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.indexing.LegacyMSQSpec;
import org.apache.druid.msq.indexing.QueryDefMSQSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.logical.DruidLogicalToQueryDefinitionTranslator;
import org.apache.druid.msq.logical.StageMaker;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.msq.sql.MSQTaskQueryMaker;
import org.apache.druid.query.QueryContext;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.QueryUtils;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.run.QueryMaker;

class PrePlannedDartQueryMaker
implements QueryMaker,
QueryMaker.FromDruidLogical {
    private PlannerContext plannerContext;
    private DartQueryMaker dartQueryMaker;

    public PrePlannedDartQueryMaker(PlannerContext plannerContext, DartQueryMaker queryMaker) {
        this.plannerContext = plannerContext;
        this.dartQueryMaker = queryMaker;
    }

    public QueryResponse<Object[]> runQuery(DruidLogicalNode rootRel) {
        if (!this.plannerContext.getAuthorizationResult().allowAccessWithNoRestriction()) {
            throw new ForbiddenException(this.plannerContext.getAuthorizationResult().getErrorMessage());
        }
        DruidLogicalToQueryDefinitionTranslator qdt = new DruidLogicalToQueryDefinitionTranslator(this.plannerContext);
        LogicalStage logicalStage = qdt.translate(rootRel);
        StageMaker maker = new StageMaker(this.plannerContext);
        maker.buildStage(logicalStage);
        QueryDefinition queryDef = maker.buildQueryDefinition();
        QueryContext context = this.plannerContext.queryContext();
        ColumnMappings columnMappings = QueryUtils.buildColumnMappings(this.dartQueryMaker.fieldMapping, (RowSignature)logicalStage.getLogicalRowSignature());
        QueryDefMSQSpec querySpec = MSQTaskQueryMaker.makeQueryDefMSQSpec(null, context, columnMappings, this.plannerContext, null, queryDef);
        ResultsContext resultsContext = MSQTaskQueryMaker.makeSimpleResultContext(querySpec.getQueryDef(), rootRel.getRowType(), this.dartQueryMaker.fieldMapping, this.plannerContext);
        QueryResponse<Object[]> response = this.dartQueryMaker.runQueryDefMSQSpec(querySpec, context, resultsContext);
        return response;
    }

    public QueryResponse<Object[]> runQuery(DruidQuery druidQuery) {
        QueryContext queryContext = druidQuery.getQuery().context();
        ResultsContext resultsContext = DartQueryMaker.makeResultsContext(druidQuery, this.dartQueryMaker.fieldMapping, this.plannerContext);
        QueryDefMSQSpec msqSpec = this.buildMSQSpec(druidQuery, this.dartQueryMaker.fieldMapping, queryContext, resultsContext);
        QueryResponse<Object[]> response = this.dartQueryMaker.runQueryDefMSQSpec(msqSpec, queryContext, resultsContext);
        return response;
    }

    private QueryDefMSQSpec buildMSQSpec(DruidQuery druidQuery, List<Map.Entry<Integer, String>> fieldMapping, QueryContext queryContext, ResultsContext resultsContext) {
        ColumnMappings columnMappings = QueryUtils.buildColumnMappings(fieldMapping, (RowSignature)druidQuery.getOutputRowSignature());
        LegacyMSQSpec querySpec = MSQTaskQueryMaker.makeLegacyMSQSpec(null, druidQuery, druidQuery.getQuery().context(), columnMappings, this.plannerContext, null);
        String dartQueryId = queryContext.getString("dartQueryId");
        QueryDefinition queryDef = new QueryKitBasedMSQPlanner(querySpec, resultsContext, querySpec.getQuery(), this.plannerContext.getJsonMapper(), this.dartQueryMaker.queryKitSpecFactory.makeQueryKitSpec(QueryKitBasedMSQPlanner.makeQueryControllerToolKit(querySpec.getContext(), this.plannerContext.getJsonMapper()), dartQueryId, querySpec.getTuningConfig(), querySpec.getContext())).makeQueryDefinition();
        return MSQTaskQueryMaker.makeQueryDefMSQSpec(null, druidQuery.getQuery().context(), columnMappings, this.plannerContext, null, queryDef);
    }
}

