/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.inject.Inject;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.timeline.DataSegment;

public class MetadataManager {
    private final AuditManager auditManager;
    private final CoordinatorConfigManager configManager;
    private final SegmentsMetadataManager segmentsMetadataManager;
    private final MetadataSupervisorManager metadataSupervisorManager;
    private final MetadataRuleManager metadataRuleManager;
    private final IndexerMetadataStorageCoordinator storageCoordinator;
    private final SegmentSchemaManager segmentSchemaManager;
    private final SegmentMetadataCache segmentMetadataCache;

    @Inject
    public MetadataManager(AuditManager auditManager, CoordinatorConfigManager configManager, SegmentsMetadataManager segmentsMetadataManager, MetadataSupervisorManager metadataSupervisorManager, MetadataRuleManager metadataRuleManager, IndexerMetadataStorageCoordinator storageCoordinator, SegmentSchemaManager segmentSchemaManager, SegmentMetadataCache segmentMetadataCache) {
        this.auditManager = auditManager;
        this.configManager = configManager;
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.metadataSupervisorManager = metadataSupervisorManager;
        this.metadataRuleManager = metadataRuleManager;
        this.storageCoordinator = storageCoordinator;
        this.segmentSchemaManager = segmentSchemaManager;
        this.segmentMetadataCache = segmentMetadataCache;
    }

    public void onLeaderStart() {
        this.segmentsMetadataManager.startPollingDatabasePeriodically();
        this.segmentsMetadataManager.populateUsedFlagLastUpdatedAsync();
        this.segmentMetadataCache.becomeLeader();
        this.metadataRuleManager.start();
    }

    public void onLeaderStop() {
        this.metadataRuleManager.stop();
        this.segmentMetadataCache.stopBeingLeader();
        this.segmentsMetadataManager.stopPollingDatabasePeriodically();
        this.segmentsMetadataManager.stopAsyncUsedFlagLastUpdatedUpdate();
    }

    public void startCache() {
        this.segmentMetadataCache.start();
    }

    public void stopCache() {
        this.segmentMetadataCache.stop();
    }

    public boolean isStarted() {
        return this.segmentsMetadataManager.isPollingDatabasePeriodically();
    }

    public AuditManager audit() {
        return this.auditManager;
    }

    public CoordinatorConfigManager configs() {
        return this.configManager;
    }

    public MetadataSupervisorManager supervisors() {
        return this.metadataSupervisorManager;
    }

    public MetadataRuleManager rules() {
        return this.metadataRuleManager;
    }

    public SegmentsMetadataManager segments() {
        return this.segmentsMetadataManager;
    }

    public IndexerMetadataStorageCoordinator indexer() {
        return this.storageCoordinator;
    }

    public SegmentSchemaManager schemas() {
        return this.segmentSchemaManager;
    }

    public Iterable<DataSegment> iterateAllUsedSegments() {
        return this.segments().getRecentDataSourcesSnapshot().iterateAllUsedSegmentsInSnapshot();
    }
}

