/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.errorprone.annotations.concurrent.GuardedBy;

public class SegmentDropLatch {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private State state = State.PENDING;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDropping() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.PENDING) {
                this.state = State.DROPPING;
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneDropping() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.DROPPING) {
                this.state = State.DONE;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelOrAwait() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.PENDING) {
                this.state = State.DONE;
            } else {
                while (this.state != State.DONE) {
                    this.lock.wait();
                }
            }
        }
    }

    static enum State {
        PENDING,
        DROPPING,
        DONE;

    }
}

