/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.timeline.SegmentId;

class SinkSchemaUtil {
    SinkSchemaUtil() {
    }

    @VisibleForTesting
    static Optional<SegmentSchemas> computeAbsoluteSchema(Map<SegmentId, Pair<RowSignature, Integer>> sinkSchemaMap) {
        ArrayList<SegmentSchemas.SegmentSchema> sinkSchemas = new ArrayList<SegmentSchemas.SegmentSchema>();
        for (Map.Entry<SegmentId, Pair<RowSignature, Integer>> entry : sinkSchemaMap.entrySet()) {
            SegmentId segmentId = entry.getKey();
            RowSignature sinkSignature = (RowSignature)entry.getValue().lhs;
            ArrayList<String> newColumns = new ArrayList<String>();
            HashMap<String, ColumnType> columnMapping = new HashMap<String, ColumnType>();
            for (String column : sinkSignature.getColumnNames()) {
                newColumns.add(column);
                sinkSignature.getColumnType(column).ifPresent(type -> columnMapping.put(column, (ColumnType)type));
            }
            Integer numRows = (Integer)entry.getValue().rhs;
            if (newColumns.size() <= 0) continue;
            SegmentSchemas.SegmentSchema segmentSchema = new SegmentSchemas.SegmentSchema(segmentId.getDataSource(), segmentId.toString(), false, numRows, newColumns, Collections.emptyList(), columnMapping);
            sinkSchemas.add(segmentSchema);
        }
        return Optional.ofNullable(sinkSchemas.isEmpty() ? null : new SegmentSchemas(sinkSchemas));
    }

    @VisibleForTesting
    static Optional<SegmentSchemas> computeSchemaChange(Map<SegmentId, Pair<RowSignature, Integer>> previousSinkSignatureMap, Map<SegmentId, Pair<RowSignature, Integer>> currentSinkSignatureMap) {
        ArrayList<SegmentSchemas.SegmentSchema> sinkSchemas = new ArrayList<SegmentSchemas.SegmentSchema>();
        for (Map.Entry<SegmentId, Pair<RowSignature, Integer>> entry : currentSinkSignatureMap.entrySet()) {
            SegmentId segmentId = entry.getKey();
            RowSignature currentSinkSignature = (RowSignature)entry.getValue().lhs;
            Integer numRows = (Integer)entry.getValue().rhs;
            ArrayList<String> newColumns = new ArrayList<String>();
            ArrayList<String> updatedColumns = new ArrayList<String>();
            HashMap<String, ColumnType> currentColumnMapping = new HashMap<String, ColumnType>();
            boolean shouldPublish = false;
            boolean isDelta = false;
            if (!previousSinkSignatureMap.containsKey(segmentId)) {
                for (String column : currentSinkSignature.getColumnNames()) {
                    newColumns.add(column);
                    currentSinkSignature.getColumnType(column).ifPresent(type -> currentColumnMapping.put(column, (ColumnType)type));
                }
                if (newColumns.size() > 0) {
                    shouldPublish = true;
                }
            } else {
                RowSignature previousSinkSignature = (RowSignature)previousSinkSignatureMap.get((Object)segmentId).lhs;
                HashSet previousSinkDimensions = new HashSet(previousSinkSignature.getColumnNames());
                Integer previousNumRows = (Integer)previousSinkSignatureMap.get((Object)segmentId).rhs;
                for (String column : currentSinkSignature.getColumnNames()) {
                    boolean added = false;
                    if (!previousSinkDimensions.contains(column)) {
                        newColumns.add(column);
                        added = true;
                    } else if (!Objects.equals(previousSinkSignature.getColumnType(column), currentSinkSignature.getColumnType(column))) {
                        updatedColumns.add(column);
                        added = true;
                    }
                    if (!added) continue;
                    currentSinkSignature.getColumnType(column).ifPresent(type -> currentColumnMapping.put(column, (ColumnType)type));
                }
                if (!Objects.equals(numRows, previousNumRows) || updatedColumns.size() > 0 || newColumns.size() > 0) {
                    shouldPublish = true;
                    isDelta = true;
                }
            }
            if (!shouldPublish) continue;
            SegmentSchemas.SegmentSchema segmentSchema = new SegmentSchemas.SegmentSchema(segmentId.getDataSource(), segmentId.toString(), isDelta, numRows, newColumns, updatedColumns, currentColumnMapping);
            sinkSchemas.add(segmentSchema);
        }
        return Optional.ofNullable(sinkSchemas.isEmpty() ? null : new SegmentSchemas(sinkSchemas));
    }
}

