/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class VirtualPlaceholderSegment
extends RowBasedSegment<Row> {
    private final DataSegment dataSegment;

    public VirtualPlaceholderSegment(DataSegment dataSegment) {
        super(Sequences.empty(), RowAdapters.standardRow(), RowSignature.builder().addTimeColumn().build());
        this.dataSegment = dataSegment;
    }

    public SegmentId getId() {
        return this.dataSegment.getId();
    }

    @Nonnull
    public Interval getDataInterval() {
        return this.dataSegment.getInterval();
    }

    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        if (PhysicalSegmentInspector.class.equals(clazz)) {
            return (T)EmptyPhysicalInspector.INSTANCE;
        }
        return (T)super.as(clazz);
    }

    private static class EmptyPhysicalInspector
    implements PhysicalSegmentInspector {
        private static final EmptyPhysicalInspector INSTANCE = new EmptyPhysicalInspector();

        private EmptyPhysicalInspector() {
        }

        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            if ("__time".equals(column)) {
                return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.LONG);
            }
            return null;
        }

        @Nullable
        public Metadata getMetadata() {
            return null;
        }

        @Nullable
        public Comparable getMinValue(String column) {
            return null;
        }

        @Nullable
        public Comparable getMaxValue(String column) {
            return null;
        }

        public int getDimensionCardinality(String column) {
            return -1;
        }

        public int getNumRows() {
            return 0;
        }
    }
}

