/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.java.util.common.logger.Logger;
import org.joda.time.Period;

public class UnusedSegmentKillerConfig {
    private static final Logger log = new Logger(UnusedSegmentKillerConfig.class);
    @JsonProperty(value="enabled")
    private final boolean enabled;
    @JsonProperty(value="bufferPeriod")
    private final Period bufferPeriod;
    @JsonProperty(value="dutyPeriod")
    private final Period dutyPeriod;

    @JsonCreator
    public UnusedSegmentKillerConfig(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="bufferPeriod") @Nullable Period bufferPeriod, @JsonProperty(value="dutyPeriod") @Nullable Period dutyPeriod) {
        this.enabled = Configs.valueOrDefault((Boolean)enabled, (boolean)false);
        this.bufferPeriod = (Period)Configs.valueOrDefault((Object)bufferPeriod, (Object)Period.days((int)30));
        if (dutyPeriod == null) {
            this.dutyPeriod = Period.hours((int)1);
        } else {
            log.warn("The config 'druid.manager.segments.killUnused.dutyPeriod' is for testing only and should not be set in production clusters as it may have unintended side-effects.", new Object[0]);
            this.dutyPeriod = dutyPeriod;
        }
    }

    public Period getBufferPeriod() {
        return this.bufferPeriod;
    }

    public Period getDutyPeriod() {
        return this.dutyPeriod;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

