/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor.autoscaler;

import org.apache.druid.indexing.overlord.supervisor.autoscaler.AggregateFunction;

public class LagStats {
    private final long maxLag;
    private final long totalLag;
    private final long avgLag;
    private final AggregateFunction aggregateForScaling;

    public LagStats(long maxLag, long totalLag, long avgLag) {
        this(maxLag, totalLag, avgLag, AggregateFunction.SUM);
    }

    public LagStats(long maxLag, long totalLag, long avgLag, AggregateFunction aggregateForScaling) {
        this.maxLag = maxLag;
        this.totalLag = totalLag;
        this.avgLag = avgLag;
        this.aggregateForScaling = aggregateForScaling == null ? AggregateFunction.SUM : aggregateForScaling;
    }

    public long getMaxLag() {
        return this.maxLag;
    }

    public long getTotalLag() {
        return this.totalLag;
    }

    public long getAvgLag() {
        return this.avgLag;
    }

    public AggregateFunction getAggregateForScaling() {
        return this.aggregateForScaling;
    }

    public long getMetric(AggregateFunction metric) {
        switch (metric) {
            case MAX: {
                return this.getMaxLag();
            }
            case SUM: {
                return this.getTotalLag();
            }
            case AVERAGE: {
                return this.getAvgLag();
            }
        }
        throw new IllegalStateException("Unknown scale metric");
    }
}

