/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.selector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.timeline.DataSegment;

public class RandomServerSelectorStrategy
implements ServerSelectorStrategy {
    @Override
    @Nullable
    public QueryableDruidServer pick(Set<QueryableDruidServer> servers, DataSegment segment) {
        return (QueryableDruidServer)Iterators.get(servers.iterator(), (int)ThreadLocalRandom.current().nextInt(servers.size()));
    }

    @Override
    public List<QueryableDruidServer> pick(Set<QueryableDruidServer> servers, DataSegment segment, int numServersToPick) {
        if (servers.size() <= numServersToPick) {
            return ImmutableList.copyOf(servers);
        }
        ArrayList list = Lists.newArrayList(servers);
        Collections.shuffle(list, ThreadLocalRandom.current());
        return ImmutableList.copyOf(list.subList(0, numServersToPick));
    }
}

