/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.utils.JvmUtils;

@LazySingleton
public class DirectDruidClientFactory
implements QueryableDruidServer.Maker {
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final QueryWatcher queryWatcher;
    private final ObjectMapper smileMapper;
    private final HttpClient httpClient;
    private final ScheduledExecutorService queryCancellationExecutor;

    @Inject
    public DirectDruidClientFactory(ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, QueryWatcher queryWatcher, @Smile ObjectMapper smileMapper, @EscalatedClient HttpClient httpClient) {
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.queryWatcher = queryWatcher;
        this.smileMapper = smileMapper;
        this.httpClient = httpClient;
        int threadCount = Math.max(1, JvmUtils.getRuntimeInfo().getAvailableProcessors() / 2);
        this.queryCancellationExecutor = ScheduledExecutors.fixed((int)threadCount, (String)"query-cancellation-executor");
    }

    public DirectDruidClient makeDirectClient(DruidServer server) {
        return new DirectDruidClient(this.conglomerate, this.queryWatcher, this.smileMapper, this.httpClient, server.getScheme(), server.getHost(), this.emitter, this.queryCancellationExecutor);
    }

    @Override
    public QueryableDruidServer make(DruidServer server) {
        return new QueryableDruidServer(server, this.makeDirectClient(server));
    }
}

