/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.ICSVWriter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;

public class StatefulBeanToCsvBuilder<T> {
    private char separator = (char)44;
    private char quotechar = (char)34;
    private char escapechar = (char)34;
    private String lineEnd = "\n";
    private MappingStrategy<T> mappingStrategy = null;
    private final Writer writer;
    private final ICSVWriter csvWriter;
    private boolean throwExceptions = true;
    private boolean orderedResults = true;
    private Locale errorLocale = Locale.getDefault();
    private boolean applyQuotesToAll = true;

    private StatefulBeanToCsvBuilder() {
        throw new IllegalStateException(String.format(ResourceBundle.getBundle("opencsv").getString("nullary.constructor.not.allowed"), this.getClass().getName()));
    }

    public StatefulBeanToCsvBuilder(Writer writer) {
        this.writer = writer;
        this.csvWriter = null;
    }

    public StatefulBeanToCsvBuilder(ICSVWriter icsvWriter) {
        this.writer = null;
        this.csvWriter = icsvWriter;
    }

    public StatefulBeanToCsvBuilder<T> withMappingStrategy(MappingStrategy<T> mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withQuotechar(char quotechar) {
        this.quotechar = quotechar;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withEscapechar(char escapechar) {
        this.escapechar = escapechar;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withLineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withOrderedResults(boolean orderedResults) {
        this.orderedResults = orderedResults;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withErrorLocale(Locale errorLocale) {
        this.errorLocale = (Locale)ObjectUtils.defaultIfNull((Object)errorLocale, (Object)Locale.getDefault());
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withApplyQuotesToAll(boolean applyQuotesToAll) {
        this.applyQuotesToAll = applyQuotesToAll;
        return this;
    }

    public StatefulBeanToCsv<T> build() {
        StatefulBeanToCsv<T> sbtcsv = this.writer != null ? new StatefulBeanToCsv<T>(this.escapechar, this.lineEnd, this.mappingStrategy, this.quotechar, this.separator, this.throwExceptions, this.writer, this.applyQuotesToAll) : new StatefulBeanToCsv<T>(this.mappingStrategy, this.throwExceptions, this.applyQuotesToAll, this.csvWriter);
        sbtcsv.setOrderedResults(this.orderedResults);
        sbtcsv.setErrorLocale(this.errorLocale);
        return sbtcsv;
    }
}

