/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.execution;

import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.k8s.overlord.execution.KubernetesTaskRunnerDynamicConfig;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.security.AuthorizationUtils;
import org.joda.time.Interval;

@Path(value="/druid/indexer/v1/k8s/taskrunner/executionconfig")
public class KubernetesTaskExecutionConfigResource {
    private static final Logger log = new Logger(KubernetesTaskExecutionConfigResource.class);
    private final JacksonConfigManager configManager;
    private final AuditManager auditManager;
    private AtomicReference<KubernetesTaskRunnerDynamicConfig> dynamicConfigRef = null;

    @Inject
    public KubernetesTaskExecutionConfigResource(JacksonConfigManager configManager, AuditManager auditManager) {
        this.configManager = configManager;
        this.auditManager = auditManager;
    }

    @POST
    @Consumes(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response setExecutionConfig(KubernetesTaskRunnerDynamicConfig dynamicConfig, @Context HttpServletRequest req) {
        ConfigManager.SetResult setResult = this.configManager.set("k8s.taskrunner.config", (Object)dynamicConfig, AuthorizationUtils.buildAuditInfo((HttpServletRequest)req));
        if (setResult.isOk()) {
            log.info("Updating K8s execution configs: %s", new Object[]{dynamicConfig});
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getExecutionConfigHistory(@QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        Interval theInterval;
        Interval interval2 = theInterval = interval == null ? null : Intervals.of((String)interval);
        if (theInterval == null && count != null) {
            try {
                List executionEntryList = this.auditManager.fetchAuditHistory("k8s.taskrunner.config", "k8s.taskrunner.config", count.intValue());
                return Response.ok((Object)executionEntryList).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
            }
        }
        List executionEntryList = this.auditManager.fetchAuditHistory("k8s.taskrunner.config", "k8s.taskrunner.config", theInterval);
        return Response.ok((Object)executionEntryList).build();
    }

    @GET
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getExecutionConfig() {
        if (this.dynamicConfigRef == null) {
            this.dynamicConfigRef = this.configManager.watch("k8s.taskrunner.config", KubernetesTaskRunnerDynamicConfig.class);
        }
        return Response.ok((Object)this.dynamicConfigRef.get()).build();
    }
}

