/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaEntryCache;

public class InMemorySchemaEntryCache
implements SchemaEntryCache {
    private final ConcurrentHashMap<String, SchemaEntry> schemaToEntry = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SchemaEntry> idToSchema = new ConcurrentHashMap();
    private final LinkedList<SchemaEntry> schemasInOrder = new LinkedList();

    @Override
    public SchemaEntry lookupBySchema(String schema) {
        return this.schemaToEntry.get(schema);
    }

    @Override
    public SchemaEntry lookupById(String id) {
        return this.idToSchema.get(id);
    }

    @Override
    public synchronized SchemaEntry add(SchemaEntry entry) {
        if (null == entry) {
            return entry;
        }
        SchemaEntry prior = this.schemaToEntry.putIfAbsent(entry.getSchema(), entry);
        if (null != prior) {
            entry = prior;
        }
        this.idToSchema.put(entry.getId(), entry);
        this.schemasInOrder.push(entry);
        return entry;
    }

    public synchronized Iterable<SchemaEntry> values() {
        return new ArrayList<SchemaEntry>(this.schemasInOrder);
    }

    public static class Factory
    implements SchemaEntryCache.Factory {
        @Override
        public SchemaEntryCache createSchemaEntryCache() {
            return new InMemorySchemaEntryCache();
        }
    }
}

