/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.nio.ByteOrder;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ClassicUtil;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int FLAGS_BYTE = 3;
    static final int K_SHORT = 4;
    static final int N_LONG = 8;
    static final int MIN_DOUBLE = 16;
    static final int MAX_DOUBLE = 24;
    static final int COMBINED_BUFFER = 32;
    static final int BIG_ENDIAN_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    static final int DEFAULT_K = 128;

    private PreambleUtil() {
    }

    static String toString(byte[] byteArr, boolean isDoublesSketch) {
        Memory mem = Memory.wrap((byte[])byteArr);
        return PreambleUtil.toString(mem, isDoublesSketch);
    }

    static String toString(Memory mem, boolean isDoublesSketch) {
        return PreambleUtil.memoryToString(mem, isDoublesSketch);
    }

    private static String memoryToString(Memory srcMem, boolean isDoublesSketch) {
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        String famName = Family.idToFamily(familyID).toString();
        int flags = PreambleUtil.extractFlags(srcMem);
        boolean bigEndian = (flags & 1) > 0;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        boolean compact = (flags & 8) > 0;
        boolean ordered = (flags & 0x10) > 0;
        int k = PreambleUtil.extractK(srcMem);
        long n = preLongs == 1 ? 0L : PreambleUtil.extractN(srcMem);
        double minDouble = Double.NaN;
        double maxDouble = Double.NaN;
        if (preLongs > 1 && isDoublesSketch) {
            minDouble = PreambleUtil.extractMinDouble(srcMem);
            maxDouble = PreambleUtil.extractMaxDouble(srcMem);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ClassicUtil.LS);
        sb.append("### QUANTILES SKETCH PREAMBLE SUMMARY:").append(ClassicUtil.LS);
        sb.append("Byte  0: Preamble Longs       : ").append(preLongs).append(ClassicUtil.LS);
        sb.append("Byte  1: Serialization Version: ").append(serVer).append(ClassicUtil.LS);
        sb.append("Byte  2: Family               : ").append(famName).append(ClassicUtil.LS);
        sb.append("Byte  3: Flags Field          : ").append(String.format("%02o", flags)).append(ClassicUtil.LS);
        sb.append("  BIG ENDIAN                  : ").append(bigEndian).append(ClassicUtil.LS);
        sb.append("  (Native Byte Order)         : ").append(nativeOrder).append(ClassicUtil.LS);
        sb.append("  READ ONLY                   : ").append(readOnly).append(ClassicUtil.LS);
        sb.append("  EMPTY                       : ").append(empty).append(ClassicUtil.LS);
        sb.append("  COMPACT                     : ").append(compact).append(ClassicUtil.LS);
        sb.append("  ORDERED                     : ").append(ordered).append(ClassicUtil.LS);
        sb.append("Bytes  4-5  : K               : ").append(k).append(ClassicUtil.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(ClassicUtil.LS);
        }
        sb.append("Bytes  8-15 : N                : ").append(n).append(ClassicUtil.LS);
        if (isDoublesSketch) {
            sb.append("MinDouble                      : ").append(minDouble).append(ClassicUtil.LS);
            sb.append("MaxDouble                      : ").append(maxDouble).append(ClassicUtil.LS);
        }
        sb.append("Retained Items                 : ").append(ClassicUtil.computeRetainedItems(k, n)).append(ClassicUtil.LS);
        sb.append("Total Bytes                    : ").append(srcMem.getCapacity()).append(ClassicUtil.LS);
        sb.append("### END SKETCH PREAMBLE SUMMARY").append(ClassicUtil.LS);
        return sb.toString();
    }

    static int extractPreLongs(Memory mem) {
        return mem.getByte(0L) & 0xFF;
    }

    static int extractSerVer(Memory mem) {
        return mem.getByte(1L) & 0xFF;
    }

    static int extractFamilyID(Memory mem) {
        return mem.getByte(2L) & 0xFF;
    }

    static int extractFlags(Memory mem) {
        return mem.getByte(3L) & 0xFF;
    }

    static int extractK(Memory mem) {
        return mem.getShort(4L) & 0xFFFF;
    }

    static long extractN(Memory mem) {
        return mem.getLong(8L);
    }

    static double extractMinDouble(Memory mem) {
        return mem.getDouble(16L);
    }

    static double extractMaxDouble(Memory mem) {
        return mem.getDouble(24L);
    }

    static void insertPreLongs(WritableMemory wmem, int numPreLongs) {
        wmem.putByte(0L, (byte)numPreLongs);
    }

    static void insertSerVer(WritableMemory wmem, int serVer) {
        wmem.putByte(1L, (byte)serVer);
    }

    static void insertFamilyID(WritableMemory wmem, int famId) {
        wmem.putByte(2L, (byte)famId);
    }

    static void insertFlags(WritableMemory wmem, int flags) {
        wmem.putByte(3L, (byte)flags);
    }

    static void insertK(WritableMemory wmem, int k) {
        wmem.putShort(4L, (short)k);
    }

    static void insertN(WritableMemory wmem, long n) {
        wmem.putLong(8L, n);
    }

    static void insertMinDouble(WritableMemory wmem, double minDouble) {
        wmem.putDouble(16L, minDouble);
    }

    static void insertMaxDouble(WritableMemory wmem, double maxDouble) {
        wmem.putDouble(24L, maxDouble);
    }
}

