/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.PreambleUtil;

final class DoublesByteArrayImpl {
    private DoublesByteArrayImpl() {
    }

    static byte[] toByteArray(DoublesSketch sketch, boolean ordered, boolean compact) {
        boolean empty = sketch.isEmpty();
        int flags = (empty ? 4 : 0) | (ordered ? 16 : 0) | (compact ? 10 : 0);
        if (empty && !sketch.hasMemory()) {
            byte[] outByteArr = new byte[8];
            WritableMemory memOut = WritableMemory.writableWrap((byte[])outByteArr);
            boolean preLongs = true;
            DoublesByteArrayImpl.insertPre0(memOut, 1, flags, sketch.getK());
            return outByteArr;
        }
        return DoublesByteArrayImpl.convertToByteArray(sketch, flags, ordered, compact);
    }

    private static byte[] convertToByteArray(DoublesSketch sketch, int flags, boolean ordered, boolean compact) {
        int preLongs = 2;
        int extra = 2;
        int prePlusExtraBytes = 32;
        int k = sketch.getK();
        long n = sketch.getN();
        DoublesSketchAccessor dsa = DoublesSketchAccessor.wrap(sketch, !compact);
        int outBytes = compact ? sketch.getCurrentCompactSerializedSizeBytes() : sketch.getCurrentUpdatableSerializedSizeBytes();
        byte[] outByteArr = new byte[outBytes];
        WritableMemory memOut = WritableMemory.writableWrap((byte[])outByteArr);
        DoublesByteArrayImpl.insertPre0(memOut, 2, flags, k);
        if (sketch.isEmpty()) {
            return outByteArr;
        }
        PreambleUtil.insertN(memOut, n);
        PreambleUtil.insertMinDouble(memOut, sketch.isEmpty() ? Double.NaN : sketch.getMinItem());
        PreambleUtil.insertMaxDouble(memOut, sketch.isEmpty() ? Double.NaN : sketch.getMaxItem());
        long memOffsetBytes = 32L;
        int bbCnt = ClassicUtil.computeBaseBufferItems(k, n);
        if (bbCnt > 0) {
            double[] bbItemsArr = dsa.getArray(0, bbCnt);
            if (ordered) {
                Arrays.sort(bbItemsArr);
            }
            memOut.putDoubleArray(memOffsetBytes, bbItemsArr, 0, bbCnt);
        }
        memOffsetBytes += (long)((compact ? bbCnt : 2 * k) << 3);
        int totalLevels = ClassicUtil.computeTotalLevels(sketch.getBitPattern());
        for (int lvl = 0; lvl < totalLevels; ++lvl) {
            dsa.setLevel(lvl);
            if (dsa.numItems() <= 0) continue;
            assert (dsa.numItems() == k);
            memOut.putDoubleArray(memOffsetBytes, dsa.getArray(0, k), 0, k);
            memOffsetBytes += (long)(k << 3);
        }
        return outByteArr;
    }

    private static void insertPre0(WritableMemory wmem, int preLongs, int flags, int k) {
        PreambleUtil.insertPreLongs(wmem, preLongs);
        PreambleUtil.insertSerVer(wmem, 3);
        PreambleUtil.insertFamilyID(wmem, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(wmem, flags);
        PreambleUtil.insertK(wmem, k);
    }
}

