/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;

public class HashBasedNumberedPartialShardSpec
implements PartialShardSpec {
    public static final String TYPE = "hashed";
    @Nullable
    private final List<String> partitionDimensions;
    private final int bucketId;
    private final int numBuckets;
    @Nullable
    private final HashPartitionFunction partitionFunction;

    @JsonCreator
    public HashBasedNumberedPartialShardSpec(@JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="numPartitions") int numBuckets, @JsonProperty(value="partitionFunction") @Nullable HashPartitionFunction partitionFunction) {
        this.partitionDimensions = partitionDimensions;
        this.bucketId = bucketId;
        this.numBuckets = numBuckets;
        this.partitionFunction = partitionFunction;
    }

    @Nullable
    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty(value="numPartitions")
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty
    @Nullable
    public HashPartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    @Override
    public ShardSpec complete(ObjectMapper objectMapper, int partitionId, int numCorePartitions) {
        return new HashBasedNumberedShardSpec(partitionId, numCorePartitions, this.bucketId, this.numBuckets, this.partitionDimensions, this.partitionFunction, objectMapper);
    }

    @Override
    public Class<? extends ShardSpec> getShardSpecClass() {
        return HashBasedNumberedShardSpec.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashBasedNumberedPartialShardSpec that = (HashBasedNumberedPartialShardSpec)o;
        return this.bucketId == that.bucketId && this.numBuckets == that.numBuckets && Objects.equals(this.partitionDimensions, that.partitionDimensions) && Objects.equals((Object)this.partitionFunction, (Object)that.partitionFunction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionDimensions, this.bucketId, this.numBuckets, this.partitionFunction});
    }
}

