/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.transform;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.transform.RowFunction;
import org.apache.druid.segment.transform.Transform;

public class ExpressionTransform
implements Transform {
    private final String name;
    private final String expression;
    private final ExprMacroTable macroTable;
    private final java.util.function.Supplier<Expr> parsedExpression;

    @JsonCreator
    public ExpressionTransform(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.expression = (String)Preconditions.checkNotNull((Object)expression, (Object)"expression");
        this.macroTable = macroTable;
        this.parsedExpression = () -> ((Supplier)Suppliers.memoize(() -> Parser.parse(expression, (ExprMacroTable)Preconditions.checkNotNull((Object)this.macroTable, (Object)"macroTable")))).get();
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Override
    public RowFunction getRowFunction() {
        return new ExpressionRowFunction(this.name, this.parsedExpression.get());
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.parsedExpression.get().analyzeInputs().getRequiredBindings();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionTransform that = (ExpressionTransform)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression);
    }

    public String toString() {
        return "ExpressionTransform{name='" + this.name + "', expression='" + this.expression + "'}";
    }

    static class ExpressionRowFunction
    implements RowFunction {
        private final String name;
        private final Expr expr;

        ExpressionRowFunction(String name, Expr expr) {
            this.name = name;
            this.expr = expr;
        }

        @Override
        public Object eval(Row row) {
            try {
                return this.expr.eval(InputBindings.forRow(row)).value();
            }
            catch (Throwable t) {
                throw new ISE(t, "Could not transform value for %s reason: %s", this.name, t.getMessage());
            }
        }

        @Override
        public List<String> evalDimension(Row row) {
            try {
                return Rows.objectToStrings(this.expr.eval(InputBindings.forRow(row)).value());
            }
            catch (Throwable t) {
                throw new ISE(t, "Could not transform dimension value for %s reason: %s", this.name, t.getMessage());
            }
        }
    }
}

