/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.Indexed;

public class ListIndexed<T>
implements Indexed<T> {
    private final List<T> baseList;

    public ListIndexed(List<T> baseList) {
        this.baseList = baseList;
    }

    @SafeVarargs
    public ListIndexed(T ... values) {
        this(Arrays.asList(values));
    }

    @Override
    public int size() {
        return this.baseList.size();
    }

    @Override
    public T get(int index) {
        return this.baseList.get(index);
    }

    @Override
    public int indexOf(@Nullable T value) {
        return this.baseList.indexOf(value);
    }

    @Override
    public Iterator<T> iterator() {
        return this.baseList.iterator();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("baseList", this.baseList);
    }
}

