/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnSignature;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;

public class RowSignature
implements ColumnInspector {
    private static final RowSignature EMPTY = new RowSignature(Collections.emptyList());
    private final Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>();
    private final Object2IntMap<String> columnPositions = new Object2IntOpenHashMap();
    private final List<String> columnNames;
    private final int hashCode;

    private RowSignature(List<ColumnSignature> columnTypeList) {
        this.columnPositions.defaultReturnValue(-1);
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < columnTypeList.size(); ++i) {
            ColumnSignature sig = columnTypeList.get(i);
            ColumnType existingType = this.columnTypes.get(sig.name());
            if (this.columnTypes.containsKey(sig.name()) && !Objects.equals(existingType, sig.type())) {
                throw new IAE("Column[%s] has conflicting types [%s] and [%s]", sig.name(), existingType, sig.type());
            }
            this.columnTypes.put(sig.name(), sig.type());
            this.columnPositions.put((Object)sig.name(), i);
            columnNamesBuilder.add((Object)sig.name());
        }
        this.columnNames = columnNamesBuilder.build();
        this.hashCode = this.computeHashCode();
    }

    @JsonCreator
    static RowSignature fromColumnSignatures(List<ColumnSignature> columnSignatures) {
        Builder builder = RowSignature.builder();
        for (ColumnSignature columnSignature : columnSignatures) {
            builder.add(columnSignature.name(), columnSignature.type());
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RowSignature empty() {
        return EMPTY;
    }

    public String getColumnName(int columnNumber) {
        return this.columnNames.get(columnNumber);
    }

    public Optional<ColumnType> getColumnType(String columnName) {
        return Optional.ofNullable(this.columnTypes.get(columnName));
    }

    public Optional<ColumnType> getColumnType(int columnNumber) {
        return Optional.ofNullable(this.columnTypes.get(this.getColumnName(columnNumber)));
    }

    public boolean isNumeric(String columnName) {
        return this.getColumnType(columnName).map(TypeSignature::isNumeric).orElse(false);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int size() {
        return this.columnNames.size();
    }

    public boolean contains(String columnName) {
        return this.columnPositions.containsKey((Object)columnName);
    }

    public boolean contains(int columnNumber) {
        return 0 <= columnNumber && columnNumber < this.columnNames.size();
    }

    public int indexOf(String columnName) {
        return this.columnPositions.applyAsInt((Object)columnName);
    }

    @JsonValue
    private List<ColumnSignature> asColumnSignatures() {
        ArrayList<ColumnSignature> retVal = new ArrayList<ColumnSignature>();
        for (String columnName : this.columnNames) {
            ColumnType type = this.columnTypes.get(columnName);
            retVal.add(new ColumnSignature(columnName, type));
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowSignature that = (RowSignature)o;
        return this.hashCode == that.hashCode && this.columnTypes.equals(that.columnTypes) && this.columnNames.equals(that.columnNames);
    }

    private int computeHashCode() {
        return Objects.hash(this.columnTypes, this.columnNames);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            String columnName = this.columnNames.get(i);
            s.append(columnName).append(":").append(this.columnTypes.get(columnName));
        }
        return s.append("}").toString();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.getColumnType(column).map(columnType -> {
            if (columnType.isNumeric()) {
                return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(columnType);
            }
            if (columnType.is(ValueType.COMPLEX)) {
                return ColumnCapabilitiesImpl.createDefault().setType((ColumnType)columnType).setHasNulls(true);
            }
            return new ColumnCapabilitiesImpl().setType((ColumnType)columnType);
        }).orElse(null);
    }

    public RowSignature buildSafeSignature(List<String> requestedColumnNames) {
        Builder builder = new Builder();
        for (String columnName : requestedColumnNames) {
            ColumnType columnType = this.columnTypes.get(columnName);
            if (columnType == null) {
                columnType = ColumnType.STRING;
            }
            builder.add(columnName, columnType);
        }
        return builder.build();
    }

    public List<ColumnType> getColumnTypes() {
        ArrayList<ColumnType> ret = new ArrayList<ColumnType>();
        for (String colName : this.columnNames) {
            ret.add(this.columnTypes.get(colName));
        }
        return ret;
    }

    public RowSignature withPrefix(String prefix) {
        Builder builder = new Builder();
        for (String columnName : this.columnNames) {
            ColumnType columnType = this.columnTypes.get(columnName);
            builder.add(prefix + columnName, columnType);
        }
        return builder.build();
    }

    public static class Builder {
        private final List<ColumnSignature> columnTypeList = new ArrayList<ColumnSignature>();

        private Builder() {
        }

        public Builder add(String columnName, @Nullable ColumnType columnType) {
            this.columnTypeList.add(new ColumnSignature(columnName, columnType));
            return this;
        }

        public Builder addAll(RowSignature other) {
            List<String> names = other.getColumnNames();
            for (int i = 0; i < names.size(); ++i) {
                this.add(names.get(i), other.getColumnType(i).orElse(null));
            }
            return this;
        }

        public Builder addTimeColumn() {
            return this.add("__time", ColumnType.LONG);
        }

        public Builder addDimensions(List<DimensionSpec> dimensions) {
            for (DimensionSpec dimension : dimensions) {
                this.add(dimension.getOutputName(), dimension.getOutputType());
            }
            return this;
        }

        public Builder addAggregators(List<AggregatorFactory> aggregators, Finalization finalization) {
            for (AggregatorFactory aggregator : aggregators) {
                ColumnType type;
                switch (finalization.ordinal()) {
                    case 0: {
                        type = aggregator.getResultType();
                        break;
                    }
                    case 1: {
                        type = aggregator.getIntermediateType();
                        break;
                    }
                    default: {
                        assert (finalization == Finalization.UNKNOWN);
                        type = aggregator.getIntermediateType().equals(aggregator.getResultType()) ? aggregator.getIntermediateType() : null;
                    }
                }
                this.add(aggregator.getName(), type);
            }
            return this;
        }

        public Builder addPostAggregators(List<PostAggregator> postAggregators) {
            for (PostAggregator postAggregator : postAggregators) {
                String name = (String)Preconditions.checkNotNull((Object)postAggregator.getName(), (Object)"postAggregators must have nonnull names");
                this.add(name, postAggregator.getType(this.build()));
            }
            return this;
        }

        public RowSignature build() {
            return new RowSignature(this.columnTypeList);
        }
    }

    public static enum Finalization {
        YES,
        NO,
        UNKNOWN;

    }
}

