/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.google.inject.Inject;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.Result;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryMetrics;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TimeBoundaryInspector;

public class TimeseriesQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeseriesResultValue>, TimeseriesQuery> {
    private final TimeseriesQueryQueryToolChest toolChest;
    private final TimeseriesQueryEngine engine;
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeseriesQueryRunnerFactory(TimeseriesQueryQueryToolChest toolChest, TimeseriesQueryEngine engine, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> createRunner(Segment segment) {
        return new TimeseriesQueryRunner(this.engine, segment.as(CursorFactory.class), segment.as(TimeBoundaryInspector.class));
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<Result<TimeseriesResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeseriesResultValue>>(queryProcessingPool, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeseriesResultValue>, TimeseriesQuery> getToolchest() {
        return this.toolChest;
    }

    private static class TimeseriesQueryRunner
    implements QueryRunner<Result<TimeseriesResultValue>> {
        private final TimeseriesQueryEngine engine;
        private final CursorFactory cursorFactory;
        @Nullable
        private final TimeBoundaryInspector timeBoundaryInspector;

        private TimeseriesQueryRunner(TimeseriesQueryEngine engine, CursorFactory cursorFactory, @Nullable TimeBoundaryInspector timeBoundaryInspector) {
            this.engine = engine;
            this.cursorFactory = cursorFactory;
            this.timeBoundaryInspector = timeBoundaryInspector;
        }

        @Override
        public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<TimeseriesResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TimeseriesQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", input.getClass(), TimeseriesQuery.class);
            }
            return this.engine.process((TimeseriesQuery)input, this.cursorFactory, this.timeBoundaryInspector, (TimeseriesQueryMetrics)queryPlus.getQueryMetrics());
        }
    }
}

