/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.collections.StupidPool;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.CursorGranularizer;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryMetrics;
import org.apache.druid.query.timeseries.TimeseriesResultBuilder;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.query.vector.VectorCursorGranularizer;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.SegmentMissingException;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.Interval;

public class TimeseriesQueryEngine {
    private final NonBlockingPool<ByteBuffer> bufferPool;

    @VisibleForTesting
    public TimeseriesQueryEngine() {
        this.bufferPool = new StupidPool<ByteBuffer>("dummy", () -> ByteBuffer.allocate(10000000));
    }

    @Inject
    public TimeseriesQueryEngine(@Global NonBlockingPool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
    }

    public Sequence<Result<TimeseriesResultValue>> process(TimeseriesQuery query, CursorFactory cursorFactory, @Nullable TimeBoundaryInspector timeBoundaryInspector, @Nullable TimeseriesQueryMetrics timeseriesQueryMetrics) {
        if (cursorFactory == null) {
            throw new SegmentMissingException("Null cursor factory found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        Interval interval = (Interval)Iterables.getOnlyElement(query.getIntervals());
        Granularity gran = query.getGranularity();
        CursorHolder cursorHolder = cursorFactory.makeCursorHolder(TimeseriesQueryEngine.makeCursorBuildSpec(query, timeseriesQueryMetrics));
        if (cursorHolder.isPreAggregated()) {
            query = query.withAggregatorSpecs((List)Preconditions.checkNotNull(cursorHolder.getAggregatorsForPreAggregated()));
        }
        try {
            Sequence<Result<TimeseriesResultValue>> result = query.context().getVectorize().shouldVectorize(cursorHolder.canVectorize()) ? this.processVectorized(query, cursorHolder, timeBoundaryInspector, interval, gran) : this.processNonVectorized(query, cursorHolder, timeBoundaryInspector, interval, gran);
            int limit = query.getLimit();
            if (limit < Integer.MAX_VALUE) {
                return result.limit(limit).withBaggage(cursorHolder);
            }
            return result.withBaggage(cursorHolder);
        }
        catch (Throwable t) {
            cursorHolder.close();
            throw t;
        }
    }

    private Sequence<Result<TimeseriesResultValue>> processVectorized(TimeseriesQuery query, CursorHolder cursorHolder, @Nullable TimeBoundaryInspector timeBoundaryInspector, Interval queryInterval, Granularity gran) {
        boolean skipEmptyBuckets = query.isSkipEmptyBuckets();
        List<AggregatorFactory> aggregatorSpecs = query.getAggregatorSpecs();
        VectorCursor cursor = cursorHolder.asVectorCursor();
        if (cursor == null) {
            return Sequences.empty();
        }
        Closer closer = Closer.create();
        try {
            VectorCursorGranularizer granularizer = VectorCursorGranularizer.create(cursor, timeBoundaryInspector, cursorHolder.getTimeOrder(), gran, queryInterval);
            if (granularizer == null) {
                return Sequences.withBaggage(Sequences.empty(), closer);
            }
            VectorColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            AggregatorAdapters aggregators = AggregatorAdapters.factorizeVector(columnSelectorFactory, query.getAggregatorSpecs());
            closer.register(aggregators::reset);
            ResourceHolder<ByteBuffer> bufferHolder = closer.register(this.bufferPool.take());
            ByteBuffer buffer = bufferHolder.get();
            if (aggregators.spaceNeeded() > buffer.remaining()) {
                throw new ISE("Not enough space for aggregators, needed [%,d] bytes but have only [%,d].", aggregators.spaceNeeded(), buffer.remaining());
            }
            return Sequences.withBaggage(Sequences.simple(granularizer.getBucketIterable()).map(bucketInterval -> {
                boolean emptyBucket = true;
                while (!cursor.isDone()) {
                    granularizer.setCurrentOffsets((Interval)bucketInterval);
                    if (granularizer.getEndOffset() > granularizer.getStartOffset()) {
                        if (emptyBucket) {
                            aggregators.init(buffer, 0);
                        }
                        aggregators.aggregateVector(buffer, 0, granularizer.getStartOffset(), granularizer.getEndOffset());
                        emptyBucket = false;
                    }
                    if (granularizer.advanceCursorWithinBucket()) continue;
                }
                if (emptyBucket && skipEmptyBuckets) {
                    return null;
                }
                TimeseriesResultBuilder bob = new TimeseriesResultBuilder(gran.toDateTime(bucketInterval.getStartMillis()));
                if (emptyBucket) {
                    aggregators.init(buffer, 0);
                }
                for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                    bob.addMetric(((AggregatorFactory)aggregatorSpecs.get(i)).getName(), aggregators.get(buffer, 0, i));
                }
                return bob.build();
            }).filter((Predicate<Result>)((Predicate)Objects::nonNull)), closer);
        }
        catch (Throwable t1) {
            try {
                closer.close();
            }
            catch (Throwable t2) {
                t1.addSuppressed(t2);
            }
            throw t1;
        }
    }

    private Sequence<Result<TimeseriesResultValue>> processNonVectorized(TimeseriesQuery query, CursorHolder cursorHolder, @Nullable TimeBoundaryInspector timeBoundaryInspector, Interval queryInterval, Granularity gran) {
        boolean skipEmptyBuckets = query.isSkipEmptyBuckets();
        List<AggregatorFactory> aggregatorSpecs = query.getAggregatorSpecs();
        Cursor cursor = cursorHolder.asCursor();
        if (cursor == null) {
            return Sequences.empty();
        }
        CursorGranularizer granularizer = CursorGranularizer.create(cursor, timeBoundaryInspector, cursorHolder.getTimeOrder(), gran, queryInterval);
        if (granularizer == null) {
            return Sequences.empty();
        }
        ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
        return Sequences.simple(granularizer.getBucketIterable()).map(bucketInterval -> {
            boolean emptyBucket = true;
            boolean advancedToBucket = granularizer.advanceToBucket((Interval)bucketInterval);
            if ((!advancedToBucket || cursor.isDone()) && skipEmptyBuckets) {
                return null;
            }
            Aggregator[] aggregators = new Aggregator[aggregatorSpecs.size()];
            String[] aggregatorNames = new String[aggregatorSpecs.size()];
            for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                aggregators[i] = ((AggregatorFactory)aggregatorSpecs.get(i)).factorize(columnSelectorFactory);
                aggregatorNames[i] = ((AggregatorFactory)aggregatorSpecs.get(i)).getName();
            }
            try {
                if (advancedToBucket) {
                    while (!cursor.isDone()) {
                        for (Aggregator aggregator : aggregators) {
                            aggregator.aggregate();
                        }
                        emptyBucket = false;
                        if (granularizer.advanceCursorWithinBucket()) continue;
                    }
                }
                if (emptyBucket && skipEmptyBuckets) {
                    Result i = null;
                    return i;
                }
                TimeseriesResultBuilder bob = new TimeseriesResultBuilder(gran.toDateTime(bucketInterval.getStartMillis()));
                for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                    bob.addMetric(aggregatorNames[i], aggregators[i].get());
                }
                Result<TimeseriesResultValue> result = bob.build();
                return result;
            }
            finally {
                for (Aggregator agg : aggregators) {
                    agg.close();
                }
            }
        }).filter((Predicate<Result>)((Predicate)Objects::nonNull));
    }

    public static CursorBuildSpec makeCursorBuildSpec(TimeseriesQuery query, @Nullable QueryMetrics<?> queryMetrics) {
        return Granularities.decorateCursorBuildSpec(query, CursorBuildSpec.builder().setInterval(query.getSingleInterval()).setFilter(Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()))).setVirtualColumns(query.getVirtualColumns()).setPhysicalColumns(query.getRequiredColumns()).setAggregators(query.getAggregatorSpecs()).setQueryContext(query.context()).setPreferredOrdering(query.getGranularity().equals(Granularities.ALL) ? List.of() : (query.isDescending() ? Cursors.descendingTimeOrder() : Cursors.ascendingTimeOrder())).setQueryMetrics(queryMetrics).build());
    }
}

