/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RangeSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.FallbackPredicate;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.AllUnknownBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.ArrayElementIndexes;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class ArrayContainsElementFilter
extends AbstractOptimizableDimFilter
implements Filter {
    private final String column;
    private final ColumnType elementMatchValueType;
    @Nullable
    private final Object elementMatchValue;
    private final ExprEval<?> elementMatchValueEval;
    @Nullable
    private final FilterTuning filterTuning;
    private final DruidPredicateFactory predicateFactory;

    @JsonCreator
    public ArrayContainsElementFilter(@JsonProperty(value="column") String column, @JsonProperty(value="elementMatchValueType") ColumnType elementMatchValueType, @JsonProperty(value="elementMatchValue") @Nullable Object elementMatchValue, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        if (column == null) {
            throw InvalidInput.exception("Invalid array_contains filter, column cannot be null", new Object[0]);
        }
        this.column = column;
        if (elementMatchValueType == null) {
            throw InvalidInput.exception("Invalid array_contains filter on column [%s], elementMatchValueType cannot be null", column);
        }
        this.elementMatchValueType = elementMatchValueType;
        this.elementMatchValue = elementMatchValue;
        this.elementMatchValueEval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(elementMatchValueType), elementMatchValue);
        this.filterTuning = filterTuning;
        this.predicateFactory = new ArrayContainsPredicateFactory(this.elementMatchValueEval);
    }

    @Override
    public byte[] getCacheKey() {
        int size;
        ByteBuffer valueBuffer;
        NullableTypeStrategy<?> typeStrategy = this.elementMatchValueEval.type().getNullableStrategy();
        if (typeStrategy.write(valueBuffer = ByteBuffer.allocate(size = typeStrategy.estimateSizeBytes(this.elementMatchValueEval.value())), this.elementMatchValueEval.value(), size) < 0) {
            throw DruidException.defensive("Unable to write the for the column [%s] with value [%s] and size [%d]", this.elementMatchValueEval.value(), this.column, size);
        }
        return new CacheKeyBuilder(22).appendByte((byte)-1).appendString(this.column).appendByte((byte)-1).appendString(this.elementMatchValueType.asTypeString()).appendByte((byte)-1).appendByteArray(valueBuffer.array()).build();
    }

    @Override
    public Filter toFilter() {
        return this;
    }

    @JsonProperty
    public String getColumn() {
        return this.column;
    }

    @JsonProperty
    public ColumnType getElementMatchValueType() {
        return this.elementMatchValueType;
    }

    @JsonProperty
    public Object getElementMatchValue() {
        return this.elementMatchValue;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder bob = new DimFilter.DimFilterToStringBuilder().append("array_contains_element(").appendDimension(this.column, null).append(", ").append(this.elementMatchValueType.isArray() ? Arrays.deepToString(this.elementMatchValueEval.asArray()) : this.elementMatchValueEval.value()).append(")");
        if (!ColumnType.STRING.equals(this.elementMatchValueType)) {
            bob.append(" (" + this.elementMatchValueType.asTypeString() + ")");
        }
        return bob.appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayContainsElementFilter that = (ArrayContainsElementFilter)o;
        if (!this.column.equals(that.column)) {
            return false;
        }
        if (!Objects.equals(this.elementMatchValueType, that.elementMatchValueType)) {
            return false;
        }
        if (!Objects.equals(this.filterTuning, that.filterTuning)) {
            return false;
        }
        if (this.elementMatchValueType.isArray()) {
            return Arrays.deepEquals(this.elementMatchValueEval.asArray(), that.elementMatchValueEval.asArray());
        }
        return Objects.equals(this.elementMatchValueEval.value(), that.elementMatchValueEval.value());
    }

    public int hashCode() {
        return Objects.hash(this.column, this.elementMatchValueType, this.elementMatchValueEval.value(), this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (!Filters.checkFilterTuningUseIndex(this.column, selector, this.filterTuning)) {
            return null;
        }
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.column);
        if (indexSupplier == null) {
            return new AllUnknownBitmapColumnIndex(selector);
        }
        ArrayElementIndexes elementIndexes = indexSupplier.as(ArrayElementIndexes.class);
        if (elementIndexes != null) {
            return elementIndexes.containsValue(this.elementMatchValueEval.value(), this.elementMatchValueType);
        }
        if (this.elementMatchValueEval.value() != null && selector.getColumnCapabilities(this.column) != null && !selector.getColumnCapabilities(this.column).isArray()) {
            return EqualityFilter.getEqualityIndex(this.column, this.elementMatchValueEval, this.elementMatchValueType, selector, this.predicateFactory);
        }
        return null;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return ColumnProcessors.makeProcessor(this.column, new TypedConstantElementValueMatcherFactory(this.elementMatchValueEval, this.predicateFactory), factory);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        ColumnCapabilities capabilities = factory.getColumnCapabilities(this.column);
        if (this.elementMatchValueEval.value() != null && this.elementMatchValueType.isPrimitive() && (capabilities == null || capabilities.isPrimitive())) {
            return ColumnProcessors.makeVectorProcessor(this.column, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.elementMatchValueEval.value(), this.elementMatchValueType);
        }
        return ColumnProcessors.makeVectorProcessor(this.column, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.predicateFactory);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.column);
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.column);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, columnRewrites);
        }
        return new ArrayContainsElementFilter(rewriteDimensionTo, this.elementMatchValueType, this.elementMatchValue, this.filterTuning);
    }

    private static class ArrayContainsPredicateFactory
    implements DruidPredicateFactory {
        private final ExprEval<?> elementMatchValue;
        private final EqualityFilter.EqualityPredicateFactory equalityPredicateFactory;
        private final Supplier<DruidObjectPredicate<String>> stringPredicateSupplier;
        private final Supplier<DruidLongPredicate> longPredicateSupplier;
        private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
        private final Supplier<DruidDoublePredicate> doublePredicateSupplier;
        private final ConcurrentHashMap<TypeSignature<ValueType>, DruidObjectPredicate<Object[]>> arrayPredicates;
        private final Supplier<DruidObjectPredicate<Object[]>> typeDetectingArrayPredicateSupplier;
        private final Supplier<DruidObjectPredicate<Object>> objectPredicateSupplier;

        public ArrayContainsPredicateFactory(ExprEval<?> elementMatchValue) {
            this.elementMatchValue = elementMatchValue;
            this.equalityPredicateFactory = new EqualityFilter.EqualityPredicateFactory(elementMatchValue);
            Object matchVal = elementMatchValue.value();
            if (matchVal == null || elementMatchValue.isArray() && elementMatchValue.asArray().length > 1) {
                this.stringPredicateSupplier = DruidObjectPredicate::alwaysFalseWithNullUnknown;
                this.longPredicateSupplier = () -> DruidLongPredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                this.doublePredicateSupplier = () -> DruidDoublePredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                this.floatPredicateSupplier = () -> DruidFloatPredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
            } else {
                this.stringPredicateSupplier = this.equalityPredicateFactory::makeStringPredicate;
                this.longPredicateSupplier = this.equalityPredicateFactory::makeLongPredicate;
                this.doublePredicateSupplier = this.equalityPredicateFactory::makeDoublePredicate;
                this.floatPredicateSupplier = this.equalityPredicateFactory::makeFloatPredicate;
            }
            this.objectPredicateSupplier = this.makeObjectPredicateSupplier();
            this.arrayPredicates = new ConcurrentHashMap();
            this.typeDetectingArrayPredicateSupplier = this.makeTypeDetectingArrayPredicate();
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            return (DruidObjectPredicate)this.stringPredicateSupplier.get();
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return (DruidLongPredicate)this.longPredicateSupplier.get();
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return (DruidFloatPredicate)this.floatPredicateSupplier.get();
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return (DruidDoublePredicate)this.doublePredicateSupplier.get();
        }

        @Override
        public DruidObjectPredicate<Object[]> makeArrayPredicate(@Nullable TypeSignature<ValueType> arrayType) {
            if (arrayType == null) {
                return (DruidObjectPredicate)this.typeDetectingArrayPredicateSupplier.get();
            }
            return new FallbackPredicate<Object[]>(this.computeArrayPredicate(arrayType), ExpressionType.fromColumnTypeStrict(arrayType));
        }

        @Override
        public DruidObjectPredicate<Object> makeObjectPredicate() {
            return (DruidObjectPredicate)this.objectPredicateSupplier.get();
        }

        private Supplier<DruidObjectPredicate<Object>> makeObjectPredicateSupplier() {
            return Suppliers.memoize(() -> input -> {
                if (input == null) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                ExprEval<?> inputEval = ExprEval.bestEffortOf(StructuredData.unwrap(input));
                FallbackPredicate<Object[]> matcher = new FallbackPredicate<Object[]>(this.computeArrayPredicate(ExpressionType.toColumnType(inputEval.asArrayType())), inputEval.asArrayType());
                return matcher.apply(inputEval.asArray());
            });
        }

        private DruidObjectPredicate<Object[]> computeArrayPredicate(TypeSignature<ValueType> arrayType) {
            return this.arrayPredicates.computeIfAbsent(arrayType, existing -> this.makeArrayPredicateInternal(arrayType));
        }

        private Supplier<DruidObjectPredicate<Object[]>> makeTypeDetectingArrayPredicate() {
            return Suppliers.memoize(() -> input -> {
                if (input == null) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                DruidObjectPredicate objectPredicate = (DruidObjectPredicate)this.objectPredicateSupplier.get();
                return objectPredicate.apply(input);
            });
        }

        private DruidObjectPredicate<Object[]> makeArrayPredicateInternal(TypeSignature<ValueType> arrayType) {
            ExpressionType expressionType = ExpressionType.fromColumnTypeStrict(arrayType);
            NullableTypeStrategy elementComparator = arrayType.getElementType().getNullableStrategy();
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.elementMatchValue, (ExpressionType)expressionType.getElementType());
            if (castForComparison == null) {
                return DruidObjectPredicate.alwaysFalseWithNullUnknown();
            }
            Object matchVal = castForComparison.value();
            return input -> {
                if (input == null) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                boolean anyMatch = false;
                for (Object elem : input) {
                    anyMatch = anyMatch || elementComparator.compare(elem, matchVal) == 0;
                }
                return DruidPredicateMatch.of(anyMatch);
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayContainsPredicateFactory that = (ArrayContainsPredicateFactory)o;
            if (!Objects.equals(this.elementMatchValue.type(), that.elementMatchValue.type())) {
                return false;
            }
            if (this.elementMatchValue.isArray()) {
                return Arrays.deepEquals(this.elementMatchValue.asArray(), that.elementMatchValue.asArray());
            }
            return Objects.equals(this.elementMatchValue.value(), that.elementMatchValue.value());
        }

        public int hashCode() {
            return Objects.hash(this.elementMatchValue);
        }
    }

    private static class TypedConstantElementValueMatcherFactory
    extends EqualityFilter.TypedConstantValueMatcherFactory {
        public TypedConstantElementValueMatcherFactory(ExprEval<?> matchValue, DruidPredicateFactory predicateFactory) {
            super(matchValue, predicateFactory);
        }

        @Override
        public ValueMatcher makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            if (this.matchValue.value() == null || this.matchValue.isArray()) {
                return this.predicateMatcherFactory.makeDimensionProcessor(selector, multiValue);
            }
            return super.makeDimensionProcessor(selector, multiValue);
        }

        @Override
        public ValueMatcher makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            if (this.matchValue.value() == null || this.matchValue.isArray()) {
                return this.predicateMatcherFactory.makeFloatProcessor(selector);
            }
            return super.makeFloatProcessor(selector);
        }

        @Override
        public ValueMatcher makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            if (this.matchValue.value() == null || this.matchValue.isArray()) {
                return this.predicateMatcherFactory.makeDoubleProcessor(selector);
            }
            return super.makeDoubleProcessor(selector);
        }

        @Override
        public ValueMatcher makeLongProcessor(BaseLongColumnValueSelector selector) {
            if (this.matchValue.value() == null || this.matchValue.isArray()) {
                return this.predicateMatcherFactory.makeLongProcessor(selector);
            }
            return super.makeLongProcessor(selector);
        }
    }
}

