/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;

public class RegexpLikeExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "regexp_like";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 2);
        if (ExprUtils.isStringLiteral(args.get(1))) {
            return new RegexpLikeExpr(args);
        }
        return new RegexpLikeDynamicExpr(args);
    }

    class RegexpLikeExpr
    extends BaseRegexpLikeExpr {
        private final Expr arg;
        private final Pattern pattern;

        private RegexpLikeExpr(List<Expr> args) {
            super(args);
            Expr patternExpr = args.get(1);
            if (!ExprUtils.isStringLiteral(patternExpr)) {
                throw RegexpLikeExprMacro.this.validationFailed("pattern must be a STRING literal", new Object[0]);
            }
            String patternString = (String)patternExpr.getLiteralValue();
            this.arg = args.get(0);
            this.pattern = Pattern.compile(StringUtils.nullToEmptyNonDruidDataString(patternString));
        }

        @Override
        @Nonnull
        public ExprEval<?> eval(Expr.ObjectBinding bindings) {
            String s = this.arg.eval(bindings).asString();
            if (s == null) {
                return ExprEval.ofLong(null);
            }
            Matcher matcher = this.pattern.matcher(s);
            return ExprEval.ofLongBoolean(matcher.find());
        }
    }

    class RegexpLikeDynamicExpr
    extends BaseRegexpLikeExpr {
        private RegexpLikeDynamicExpr(List<Expr> args) {
            super(args);
        }

        @Override
        @Nonnull
        public ExprEval<?> eval(Expr.ObjectBinding bindings) {
            Expr patternExpr = ((Expr)this.args.get(1)).eval(bindings).toExpr();
            if (!ExprUtils.isStringLiteral(patternExpr)) {
                throw RegexpLikeExprMacro.this.validationFailed("pattern must be a STRING literal", new Object[0]);
            }
            String s = ((Expr)this.args.get(0)).eval(bindings).asString();
            if (s == null) {
                return ExprEval.ofLong(null);
            }
            String patternString = (String)patternExpr.getLiteralValue();
            Pattern pattern = Pattern.compile(StringUtils.nullToEmptyNonDruidDataString(patternString));
            Matcher matcher = pattern.matcher(s);
            return ExprEval.ofLongBoolean(matcher.find());
        }
    }

    abstract class BaseRegexpLikeExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        public BaseRegexpLikeExpr(List<Expr> args) {
            super(RegexpLikeExprMacro.this, args);
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }
    }
}

