/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.NoopAggregator;
import org.apache.druid.query.aggregation.NoopBufferAggregator;
import org.apache.druid.query.aggregation.NoopVectorAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityBufferAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityVectorAggregator;
import org.apache.druid.query.aggregation.cardinality.HyperLogLogCollectorAggregateCombiner;
import org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategyFactory;
import org.apache.druid.query.aggregation.cardinality.vector.CardinalityVectorProcessorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class CardinalityAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex("hyperUnique");
    private static final CardinalityAggregatorColumnSelectorStrategyFactory STRATEGY_FACTORY = new CardinalityAggregatorColumnSelectorStrategyFactory();
    private final String name;
    private final List<DimensionSpec> fields;
    private final boolean byRow;
    private final boolean round;

    private static List<String> makeRequiredFieldNamesFromFields(List<DimensionSpec> fields) {
        return ImmutableList.copyOf((Collection)Lists.transform(fields, (Function)new Function<DimensionSpec, String>(){

            public String apply(DimensionSpec input) {
                return input.getDimension();
            }
        }));
    }

    private static List<DimensionSpec> makeFieldsFromFieldNames(List<String> fieldNames) {
        return ImmutableList.copyOf((Collection)Lists.transform(fieldNames, (Function)new Function<String, DimensionSpec>(){

            public DimensionSpec apply(String input) {
                return new DefaultDimensionSpec(input, input);
            }
        }));
    }

    @JsonCreator
    public CardinalityAggregatorFactory(@JsonProperty(value="name") String name, @Deprecated @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="fields") List<DimensionSpec> fields, @JsonProperty(value="byRow") boolean byRow, @JsonProperty(value="round") boolean round) {
        this.name = name;
        if (fields == null) {
            Preconditions.checkArgument((fieldNames != null ? 1 : 0) != 0, (Object)"Must provide 'fieldNames' if 'fields' is null.");
            this.fields = CardinalityAggregatorFactory.makeFieldsFromFieldNames(fieldNames);
        } else {
            Preconditions.checkArgument((fieldNames == null ? 1 : 0) != 0, (Object)"Cannot specify both 'fieldNames' and 'fields.");
            this.fields = fields;
        }
        this.byRow = byRow;
        this.round = round;
    }

    public CardinalityAggregatorFactory(String name, List<DimensionSpec> fields, boolean byRow) {
        this(name, null, fields, byRow, false);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnFactory) {
        ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, this.fields, columnFactory);
        if (selectorPluses.length == 0) {
            return NoopAggregator.instance();
        }
        return new CardinalityAggregator(selectorPluses, this.byRow);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnFactory) {
        ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, this.fields, columnFactory);
        if (selectorPluses.length == 0) {
            return NoopBufferAggregator.instance();
        }
        return new CardinalityBufferAggregator(selectorPluses, this.byRow);
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        if (this.fields.isEmpty()) {
            return NoopVectorAggregator.instance();
        }
        return new CardinalityVectorAggregator(this.fields.stream().map(field -> ColumnProcessors.makeVectorProcessor(field, CardinalityVectorProcessorFactory.INSTANCE, selectorFactory)).collect(Collectors.toList()));
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return !this.byRow && this.fields.stream().allMatch(DimensionSpec::canVectorize);
    }

    @Override
    public Comparator getComparator() {
        return new Comparator<HyperLogLogCollector>(){

            @Override
            public int compare(HyperLogLogCollector lhs, HyperLogLogCollector rhs) {
                return lhs.compareTo(rhs);
            }
        };
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return ((HyperLogLogCollector)lhs).fold((HyperLogLogCollector)rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new HyperLogLogCollectorAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new HyperUniquesAggregatorFactory(this.name, this.name, false, this.round);
    }

    @Override
    public Object deserialize(Object object) {
        ByteBuffer buffer;
        if (object instanceof byte[]) {
            buffer = ByteBuffer.wrap((byte[])object);
        } else if (object instanceof ByteBuffer) {
            buffer = ((ByteBuffer)object).duplicate();
        } else if (object instanceof String) {
            buffer = ByteBuffer.wrap(StringUtils.decodeBase64(StringUtils.toUtf8((String)object)));
        } else {
            return object;
        }
        return HyperLogLogCollector.makeCollector(buffer);
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return HyperUniquesAggregatorFactory.estimateCardinality(object, this.round);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return CardinalityAggregatorFactory.makeRequiredFieldNamesFromFields(this.fields);
    }

    @JsonProperty
    public List<DimensionSpec> getFields() {
        return this.fields;
    }

    @JsonProperty
    public boolean isByRow() {
        return this.byRow;
    }

    @JsonProperty
    public boolean isRound() {
        return this.round;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(8).appendCacheables(this.fields).appendBoolean(this.byRow).appendBoolean(this.round).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return TYPE;
    }

    @Override
    public ColumnType getResultType() {
        return this.round ? ColumnType.LONG : ColumnType.DOUBLE;
    }

    @Override
    public int getMaxIntermediateSize() {
        return HyperLogLogCollector.getLatestNumBytesForDenseStorage();
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new CardinalityAggregatorFactory(newName, null, this.getFields(), this.byRow, this.round);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardinalityAggregatorFactory that = (CardinalityAggregatorFactory)o;
        return this.byRow == that.byRow && this.round == that.round && Objects.equals(this.name, that.name) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields, this.byRow, this.round);
    }

    public String toString() {
        return "CardinalityAggregatorFactory{name='" + this.name + "', fields=" + String.valueOf(this.fields) + ", byRow=" + this.byRow + ", round=" + this.round + "}";
    }
}

