/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleMinVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public DoubleMinVectorAggregator(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putDouble(position, Double.POSITIVE_INFINITY);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        double[] vector = this.selector.getDoubleVector();
        double min = buf.getDouble(position);
        for (int i = startRow; i < endRow; ++i) {
            min = Math.min(min, vector[i]);
        }
        buf.putDouble(position, min);
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        double[] vector = this.selector.getDoubleVector();
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            buf.putDouble(position, Math.min(buf.getDouble(position), vector[rows != null ? rows[i] : i]));
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }

    @Override
    public void close() {
    }
}

