/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.SegmentMapFunction;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=TableDataSource.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TableDataSource.class, name="table"), @JsonSubTypes.Type(value=QueryDataSource.class, name="query"), @JsonSubTypes.Type(value=UnionDataSource.class, name="union"), @JsonSubTypes.Type(value=JoinDataSource.class, name="join"), @JsonSubTypes.Type(value=LookupDataSource.class, name="lookup"), @JsonSubTypes.Type(value=InlineDataSource.class, name="inline"), @JsonSubTypes.Type(value=GlobalTableDataSource.class, name="globalTable"), @JsonSubTypes.Type(value=UnnestDataSource.class, name="unnest"), @JsonSubTypes.Type(value=FilteredDataSource.class, name="filter"), @JsonSubTypes.Type(value=RestrictedDataSource.class, name="restrict")})
public interface DataSource
extends Cacheable {
    public static final byte JOIN_OPERATION_CACHE_ID = 1;
    public static final byte TABLE_DATA_SOURCE_CACHE_ID = 2;
    public static final byte NOOP_CACHE_ID = 113;

    public Set<String> getTableNames();

    public List<DataSource> getChildren();

    public DataSource withChildren(List<DataSource> var1);

    public boolean isCacheable(boolean var1);

    public boolean isGlobal();

    public boolean isProcessable();

    public SegmentMapFunction createSegmentMapFunction(Query var1);

    default public DataSource withPolicies(Map<String, Optional<Policy>> policyMap, PolicyEnforcer policyEnforcer) {
        List<DataSource> children = this.getChildren().stream().map(child -> child.withPolicies(policyMap, policyEnforcer)).collect(Collectors.toList());
        return this.withChildren(children);
    }

    @Override
    @Nullable
    public byte[] getCacheKey();
}

