/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CaseSearchedFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public final class CaseSearchedLongVectorProcessor
extends CaseSearchedFunctionVectorProcessor<long[]> {
    private final long[] output;
    private final boolean[] outputNulls;

    public CaseSearchedLongVectorProcessor(ExprVectorProcessor<?>[] conditionProcessors, ExprVectorProcessor<long[]>[] thenProcessors) {
        super(ExpressionType.LONG, conditionProcessors, thenProcessors);
        this.output = new long[conditionProcessors[0].maxVectorSize()];
        this.outputNulls = new boolean[conditionProcessors[0].maxVectorSize()];
    }

    @Override
    protected void processThenVector(ExprEvalVector<long[]> thenVector, int currentMatches, int[] thenSelection) {
        long[] thenValues = thenVector.getLongVector();
        boolean[] thenNulls = thenVector.getNullVector();
        for (int i = 0; i < currentMatches; ++i) {
            int outIndex = thenSelection[i];
            this.output[outIndex] = thenValues[i];
            this.outputNulls[outIndex] = thenNulls != null ? thenNulls[i] : false;
        }
    }

    @Override
    protected void processElseVector(ExprEvalVector<long[]> elseVector, int[] conditionSelection) {
        long[] elseValues = elseVector.getLongVector();
        boolean[] elseNulls = elseVector.getNullVector();
        for (int i = 0; i < this.conditionBindingFilterer.getCurrentVectorSize(); ++i) {
            int outIndex = conditionSelection[i];
            this.output[outIndex] = elseValues[i];
            this.outputNulls[outIndex] = elseNulls != null ? elseNulls[i] : false;
        }
    }

    @Override
    protected void processElseNull(int[] conditionSelection) {
        for (int i = 0; i < this.conditionBindingFilterer.getCurrentVectorSize(); ++i) {
            int outIndex = conditionSelection[i];
            this.output[outIndex] = 0L;
            this.outputNulls[outIndex] = true;
        }
    }

    @Override
    protected ExprEvalVector<long[]> makeResultVector() {
        return new ExprEvalLongVector(this.output, this.outputNulls);
    }
}

