/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.partitions.DimensionBasedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;
import org.apache.druid.timeline.partition.HashPartitionFunction;

public class HashedPartitionsSpec
implements DimensionBasedPartitionsSpec {
    public static final String NAME = "hashed";
    @VisibleForTesting
    static final String NUM_SHARDS = "numShards";
    private static final HashPartitionFunction DEFAULT_HASH_FUNCTION = HashPartitionFunction.MURMUR3_32_ABS;
    @Nullable
    private final Integer maxRowsPerSegment;
    @Nullable
    private final Integer numShards;
    private final List<String> partitionDimensions;
    private final HashPartitionFunction partitionFunction;

    public static HashedPartitionsSpec defaultSpec() {
        return new HashedPartitionsSpec(null, null, null, null, null, null);
    }

    @JsonCreator
    public HashedPartitionsSpec(@JsonProperty(value="targetRowsPerSegment") @Nullable Integer targetRowsPerSegment, @JsonProperty(value="numShards") @Nullable Integer numShards, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JsonProperty(value="partitionFunction") @Nullable HashPartitionFunction partitionFunction, @Deprecated @JsonProperty(value="targetPartitionSize") @Nullable Integer targetPartitionSize, @Deprecated @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment) {
        Integer adjustedTargetRowsPerSegment = PartitionsSpec.resolveHistoricalNullIfNeeded(targetRowsPerSegment);
        Integer adjustedNumShards = PartitionsSpec.resolveHistoricalNullIfNeeded(numShards);
        Integer adjustedTargetPartitionSize = PartitionsSpec.resolveHistoricalNullIfNeeded(targetPartitionSize);
        Integer adjustedMaxRowsPerSegment = PartitionsSpec.resolveHistoricalNullIfNeeded(maxRowsPerSegment);
        Property<Integer> target = Checks.checkAtMostOneNotNull("targetRowsPerSegment", adjustedTargetRowsPerSegment, "targetPartitionSize", adjustedTargetPartitionSize);
        target = Checks.checkAtMostOneNotNull(target, new Property<Integer>("maxRowsPerSegment", adjustedMaxRowsPerSegment));
        Checks.checkAtMostOneNotNull(target, new Property<Integer>(NUM_SHARDS, adjustedNumShards));
        this.partitionDimensions = partitionDimensions == null ? Collections.emptyList() : partitionDimensions;
        this.partitionFunction = partitionFunction == null ? DEFAULT_HASH_FUNCTION : partitionFunction;
        this.numShards = adjustedNumShards;
        this.maxRowsPerSegment = target.getValue() == null ? (this.numShards == null ? Integer.valueOf(5000000) : null) : target.getValue();
        Preconditions.checkArgument((this.maxRowsPerSegment == null || this.maxRowsPerSegment > 0 ? 1 : 0) != 0, (String)"%s[%s] should be positive", (Object)target.getName(), (Object)target.getValue());
        Preconditions.checkArgument((this.numShards == null || this.numShards > 0 ? 1 : 0) != 0, (String)"numShards[%s] should be positive", (Object)this.numShards);
    }

    public HashedPartitionsSpec(@Nullable Integer maxRowsPerSegment, @Nullable Integer numShards, @Nullable List<String> partitionDimensions, @Nullable HashPartitionFunction partitionFunction) {
        this(null, numShards, partitionDimensions, partitionFunction, maxRowsPerSegment, null);
    }

    public HashedPartitionsSpec(@Nullable Integer maxRowsPerSegment, @Nullable Integer numShards, @Nullable List<String> partitionDimensions) {
        this(null, numShards, partitionDimensions, null, maxRowsPerSegment, null);
    }

    @Override
    @Nullable
    public Integer getTargetRowsPerSegment() {
        return null;
    }

    @Override
    public SecondaryPartitionType getType() {
        return SecondaryPartitionType.HASH;
    }

    @Override
    @Nullable
    @JsonProperty
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @Override
    public boolean needsDeterminePartitions(boolean useForHadoopTask) {
        return useForHadoopTask ? this.maxRowsPerSegment != null : this.numShards == null;
    }

    @Nullable
    @JsonProperty
    public Integer getNumShards() {
        return this.numShards;
    }

    @Override
    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @JsonProperty
    public HashPartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    @Override
    public String getForceGuaranteedRollupIncompatiblityReason() {
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashedPartitionsSpec that = (HashedPartitionsSpec)o;
        return Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.numShards, that.numShards) && Objects.equals(this.partitionDimensions, that.partitionDimensions) && this.partitionFunction == that.partitionFunction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxRowsPerSegment, this.numShards, this.partitionDimensions, this.partitionFunction});
    }

    public String toString() {
        return "HashedPartitionsSpec{maxRowsPerSegment=" + this.maxRowsPerSegment + ", numShards=" + this.numShards + ", partitionDimensions=" + String.valueOf(this.partitionDimensions) + ", partitionFunction=" + String.valueOf((Object)this.partitionFunction) + "}";
    }
}

