/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.exception;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.common.exception.ErrorResponseTransformStrategy;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;

public class PersonaBasedErrorTransformStrategy
implements ErrorResponseTransformStrategy {
    private static final String ERROR_WITH_ID_TEMPLATE = "Internal server error, please contact your administrator with Error ID [%s] if the issue persists.";
    public static final PersonaBasedErrorTransformStrategy INSTANCE = new PersonaBasedErrorTransformStrategy();

    @Override
    public Optional<Exception> maybeTransform(DruidException druidException, Optional<String> optionalErrorId) {
        if (druidException.getTargetPersona() == DruidException.Persona.USER) {
            return Optional.empty();
        }
        String errorId = optionalErrorId.orElse(UUID.randomUUID().toString());
        return Optional.of(DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build(StringUtils.format(ERROR_WITH_ID_TEMPLATE, errorId), new Object[0]));
    }

    @Override
    public Function<String, String> getErrorMessageTransformFunction() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return PersonaBasedErrorTransformStrategy.class.hashCode();
    }
}

