/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.prepare.BaseDruidSqlValidator;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOverOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.IdentifierNamespace;
import org.apache.calcite.sql.validate.SelectNamespace;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.druid.catalog.model.facade.DatasourceFacade;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.NativelySupportsDistinct;
import org.apache.druid.sql.calcite.expression.builtin.ScalarInArrayOperatorConversion;
import org.apache.druid.sql.calcite.parser.DruidSqlIngest;
import org.apache.druid.sql.calcite.parser.DruidSqlParserUtils;
import org.apache.druid.sql.calcite.parser.ExternalDestinationSqlIdentifier;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.utils.CollectionUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DruidSqlValidator
extends BaseDruidSqlValidator {
    private static final Pattern UNNAMED_COLUMN_PATTERN = Pattern.compile("^EXPR\\$\\d+$", 2);
    public static final String CTX_ROWS_PER_SEGMENT = "msqRowsPerSegment";
    private final PlannerContext plannerContext;

    protected DruidSqlValidator(SqlOperatorTable opTab, CalciteCatalogReader catalogReader, JavaTypeFactory typeFactory, SqlValidator.Config validatorConfig, PlannerContext plannerContext) {
        super(opTab, catalogReader, typeFactory, validatorConfig);
        this.plannerContext = plannerContext;
    }

    public void validateWindow(SqlNode windowOrId, SqlValidatorScope scope, @Nullable SqlCall call) {
        boolean hasBounds;
        SqlWindow targetWindow;
        if (this.isSqlCallDistinct(call)) {
            throw DruidSqlValidator.buildCalciteContextException("DISTINCT is not supported for window functions", windowOrId);
        }
        switch (windowOrId.getKind()) {
            case IDENTIFIER: {
                targetWindow = this.getWindowByName((SqlIdentifier)windowOrId, scope);
                break;
            }
            case WINDOW: {
                targetWindow = (SqlWindow)windowOrId;
                break;
            }
            default: {
                throw Util.unexpected((Enum)windowOrId.getKind());
            }
        }
        this.updateBoundsIfNeeded(targetWindow);
        @Nullable SqlNode lowerBound = targetWindow.getLowerBound();
        @Nullable SqlNode upperBound = targetWindow.getUpperBound();
        if (!this.isValidEndpoint(lowerBound) || !this.isValidEndpoint(upperBound)) {
            throw DruidSqlValidator.buildCalciteContextException("Window frames with expression based lower/upper bounds are not supported.", windowOrId);
        }
        boolean bl = hasBounds = lowerBound != null || upperBound != null;
        if (call.getKind() == SqlKind.NTILE && hasBounds) {
            throw DruidSqlValidator.buildCalciteContextException("Framing of NTILE is not supported.", (SqlNode)call);
        }
        if (!(call.getKind() != SqlKind.FIRST_VALUE && call.getKind() != SqlKind.LAST_VALUE || this.isUnboundedOrCurrent(lowerBound) && this.isUnboundedOrCurrent(upperBound))) {
            throw DruidSqlValidator.buildCalciteContextException("Framing of FIRST_VALUE/LAST_VALUE is only allowed with UNBOUNDED or CURRENT ROW.", (SqlNode)call);
        }
        if (!(targetWindow.isRows() || this.isUnboundedOrCurrent(lowerBound) && this.isUnboundedOrCurrent(upperBound))) {
            throw DruidSqlValidator.buildCalciteContextException("Order By with RANGE clause currently supports only UNBOUNDED or CURRENT ROW. Use ROWS clause instead.", windowOrId);
        }
        super.validateWindow(windowOrId, scope, call);
    }

    public void validateInsert(SqlInsert insert) {
        Integer targetSegmentRows;
        RelDataType withBodyType;
        SqlValidatorScope scope;
        SqlNode source;
        DatasourceFacade tableMetadata;
        IdentifierNamespace insertNs;
        DruidSqlIngest ingestNode = (DruidSqlIngest)insert;
        if (insert.isUpsert()) {
            throw InvalidSqlInput.exception((String)"UPSERT is not supported.", (Object[])new Object[0]);
        }
        String operationName = insert.getOperator().getName();
        if (insert.getTargetColumnList() != null) {
            throw InvalidSqlInput.exception((String)"Operation [%s] cannot be run with a target column list, given [%s (%s)]", (Object[])new Object[]{operationName, ingestNode.getTargetTable(), ingestNode.getTargetColumnList()});
        }
        SqlValidatorNamespace targetNamespace = Objects.requireNonNull(this.getNamespace((SqlNode)insert), () -> "namespace for " + String.valueOf(insert));
        DatasourceTable table = this.validateInsertTarget(targetNamespace, insertNs = (IdentifierNamespace)targetNamespace, operationName);
        DatasourceFacade datasourceFacade = tableMetadata = table == null ? null : table.effectiveMetadata().catalogMetadata();
        if (!(ingestNode.getTargetTable() instanceof ExternalDestinationSqlIdentifier)) {
            Granularity effectiveGranularity = this.getEffectiveGranularity(operationName, ingestNode, tableMetadata);
            try {
                this.plannerContext.queryContextMap().put("sqlInsertSegmentGranularity", this.plannerContext.getPlannerToolbox().jsonMapper().writeValueAsString((Object)effectiveGranularity));
            }
            catch (JsonProcessingException e) {
                throw InvalidSqlInput.exception((Throwable)e, (String)"Invalid partition granularity [%s]", (Object[])new Object[]{effectiveGranularity});
            }
        }
        if ((source = insert.getSource()) instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)source;
            this.validateSelect(sqlSelect, this.unknownType);
            scope = null;
        } else {
            scope = (SqlValidatorScope)this.scopes.get(source);
            this.validateQuery(source, scope, this.unknownType);
        }
        SqlValidatorNamespace sourceNamespace = (SqlValidatorNamespace)this.namespaces.get(source);
        RelRecordType sourceType = (RelRecordType)sourceNamespace.getRowType();
        RelDataType targetType = this.validateTargetType(scope, insertNs, insert, sourceType, tableMetadata);
        if (source instanceof SqlWith && (withBodyType = this.getValidatedNodeTypeIfKnown(((SqlWith)source).body)) != null) {
            this.setValidatedNodeType(source, withBodyType);
        }
        this.setValidatedNodeType((SqlNode)insert, targetType);
        if (tableMetadata != null && !this.plannerContext.queryContextMap().containsKey(CTX_ROWS_PER_SEGMENT) && (targetSegmentRows = tableMetadata.targetSegmentRows()) != null) {
            this.plannerContext.queryContextMap().put(CTX_ROWS_PER_SEGMENT, targetSegmentRows);
        }
    }

    protected SelectNamespace createSelectNamespace(SqlSelect select, SqlNode enclosingNode) {
        SqlNodeList catalogClustering = null;
        if (enclosingNode instanceof DruidSqlIngest) {
            SqlValidatorNamespace targetNamespace = Objects.requireNonNull(this.getNamespace(enclosingNode), () -> "namespace for " + String.valueOf(enclosingNode));
            IdentifierNamespace insertNs = (IdentifierNamespace)targetNamespace;
            SqlIdentifier identifier = insertNs.getId();
            SqlValidatorTable catalogTable = this.getCatalogReader().getTable((List)identifier.names);
            if (catalogTable != null) {
                DatasourceTable table = (DatasourceTable)catalogTable.unwrap(DatasourceTable.class);
                DatasourceFacade tableMetadata = table == null ? null : table.effectiveMetadata().catalogMetadata();
                catalogClustering = this.convertCatalogClustering(tableMetadata);
            }
            this.rewriteClusteringToOrderBy((SqlNode)select, (DruidSqlIngest)enclosingNode, catalogClustering);
        }
        return super.createSelectNamespace(select, enclosingNode);
    }

    private DatasourceTable validateInsertTarget(SqlValidatorNamespace targetNamespace, IdentifierNamespace insertNs, String operationName) {
        SqlIdentifier destId = insertNs.getId();
        if (destId.names.isEmpty()) {
            throw InvalidSqlInput.exception((String)"Operation [%s] requires a target table", (Object[])new Object[]{operationName});
        }
        int n = destId.names.size();
        if (n > 2) {
            throw InvalidSqlInput.exception((String)"Druid does not support 3+ part names: [%s]", (Object[])new Object[]{destId, operationName});
        }
        String tableName = (String)destId.names.get(n - 1);
        if (n == 2 && !this.plannerContext.getPlannerToolbox().druidSchemaName().equals(destId.names.get(0))) {
            throw InvalidSqlInput.exception((String)"Table [%s] does not support operation [%s] because it is not a Druid datasource", (Object[])new Object[]{destId, operationName});
        }
        try {
            this.validateNamespace(targetNamespace, this.unknownType);
            SqlValidatorTable target = insertNs.resolve().getTable();
            try {
                return (DatasourceTable)target.unwrap(DatasourceTable.class);
            }
            catch (Exception e) {
                throw InvalidSqlInput.exception((String)"Table [%s] does not support operation [%s] because it is not a Druid datasource", (Object[])new Object[]{destId, operationName});
            }
        }
        catch (CalciteContextException e) {
            if (e.getCause() instanceof SqlValidatorException && e.getMessage().contains(StringUtils.format((String)"Object '%s' not found", (Object[])new Object[]{tableName}))) {
                if (this.plannerContext.getPlannerToolbox().catalogResolver().ingestRequiresExistingTable()) {
                    throw InvalidSqlInput.exception((String)"Cannot %s into [%s] because it does not exist", (Object[])new Object[]{operationName, destId});
                }
                IdUtils.validateId((String)"table", (String)tableName);
                return null;
            }
            throw e;
        }
    }

    private void rewriteClusteringToOrderBy(SqlNode source, DruidSqlIngest ingestNode, @Nullable SqlNodeList catalogClustering) {
        SqlNodeList clusteredBy = ingestNode.getClusteredBy();
        if (clusteredBy == null || clusteredBy.getList().isEmpty()) {
            if (catalogClustering == null || catalogClustering.getList().isEmpty()) {
                return;
            }
            clusteredBy = catalogClustering;
        }
        while (source instanceof SqlWith) {
            source = (SqlNode)((SqlWith)source).getOperandList().get(1);
        }
        SqlSelect select = (SqlSelect)source;
        DruidSqlParserUtils.validateClusteredByColumns(clusteredBy);
        select.setOrderBy(clusteredBy);
    }

    private Granularity getEffectiveGranularity(String operationName, DruidSqlIngest ingestNode, @Nullable DatasourceFacade tableMetadata) {
        Granularity ingestionGranularity;
        Granularity effectiveGranularity = null;
        Granularity granularity = ingestionGranularity = ingestNode.getPartitionedBy() != null ? ingestNode.getPartitionedBy().getGranularity() : null;
        if (ingestionGranularity != null) {
            DruidSqlParserUtils.validateSupportedGranularityForPartitionedBy((SqlNode)ingestNode, ingestionGranularity);
            effectiveGranularity = ingestionGranularity;
        } else {
            Granularity definedGranularity;
            Granularity granularity2 = definedGranularity = tableMetadata == null ? null : tableMetadata.segmentGranularity();
            if (definedGranularity != null) {
                DruidSqlParserUtils.validateSupportedGranularityForPartitionedBy(null, definedGranularity);
                effectiveGranularity = definedGranularity;
            }
        }
        if (effectiveGranularity == null) {
            SqlNode source = ingestNode.getSource();
            while (source instanceof SqlWith) {
                source = (SqlNode)((SqlWith)source).getOperandList().get(1);
            }
            SqlSelect select = (SqlSelect)source;
            if (select.getOrderList() != null) {
                throw DruidSqlParserUtils.problemParsing("CLUSTERED BY found before PARTITIONED BY, CLUSTERED BY must come after the PARTITIONED BY clause");
            }
            throw InvalidSqlInput.exception((String)"Operation [%s] requires a PARTITIONED BY to be explicitly defined, but none was found.", (Object[])new Object[]{operationName});
        }
        return effectiveGranularity;
    }

    private @Nullable SqlNodeList convertCatalogClustering(DatasourceFacade tableMetadata) {
        if (tableMetadata == null) {
            return null;
        }
        List keyCols = tableMetadata.clusterKeys();
        if (CollectionUtils.isNullOrEmpty((Collection)keyCols)) {
            return null;
        }
        SqlNodeList keyNodes = new SqlNodeList(SqlParserPos.ZERO);
        for (ClusterKeySpec keyCol : keyCols) {
            SqlIdentifier colIdent = new SqlIdentifier(Collections.singletonList(keyCol.expr()), null, SqlParserPos.ZERO, Collections.singletonList(SqlParserPos.ZERO));
            Object keyNode = keyCol.desc() ? SqlStdOperatorTable.DESC.createCall(SqlParserPos.ZERO, new SqlNode[]{colIdent}) : colIdent;
            keyNodes.add((SqlNode)keyNode);
        }
        return keyNodes;
    }

    private RelDataType validateTargetType(SqlValidatorScope scope, IdentifierNamespace insertNs, SqlInsert insert, RelRecordType sourceType, DatasourceFacade tableMetadata) {
        List sourceFields = sourceType.getFieldList();
        for (RelDataTypeField sourceField : sourceFields) {
            if (!UNNAMED_COLUMN_PATTERN.matcher(sourceField.getName()).matches()) continue;
            throw DruidSqlValidator.buildCalciteContextException("Insertion requires columns to be named, but at least one of the columns was unnamed.  This is usually the result of applying a function without having an AS clause, please ensure that all function callsare named with an AS clause as in \"func(X) as myColumn\".", this.getSqlNodeFor(insert, sourceFields.indexOf(sourceField)));
        }
        boolean isCatalogValidationEnabled = this.plannerContext.queryContext().isCatalogValidationEnabled();
        if (tableMetadata == null || !isCatalogValidationEnabled) {
            return sourceType;
        }
        boolean isStrict = tableMetadata.isSealed();
        ArrayList<Pair> fields = new ArrayList<Pair>();
        for (RelDataTypeField sourceField : sourceFields) {
            String colName = sourceField.getName();
            DatasourceFacade.ColumnFacade definedCol = tableMetadata.column(colName);
            if (definedCol == null) {
                if (isStrict) {
                    throw InvalidSqlInput.exception((String)"Column [%s] is not defined in the target table [%s] strict schema", (Object[])new Object[]{colName, insert.getTargetTable()});
                }
                fields.add(Pair.of((Object)colName, (Object)sourceField.getType()));
                continue;
            }
            if (!definedCol.hasType()) {
                fields.add(Pair.of((Object)colName, (Object)sourceField.getType()));
                continue;
            }
            if (definedCol.sqlStorageType() == null) {
                fields.add(Pair.of((Object)colName, (Object)sourceField.getType()));
                continue;
            }
            RelDataType relType = this.computeTypeForDefinedCol(definedCol, sourceField);
            fields.add(Pair.of((Object)colName, (Object)this.typeFactory.createTypeWithNullability(relType, sourceField.getType().isNullable())));
        }
        RelDataType targetType = this.typeFactory.createStructType(fields);
        SqlValidatorTable target = insertNs.resolve().getTable();
        this.checkTypeAssignment(scope, target, (RelDataType)sourceType, targetType, (SqlNode)insert);
        return targetType;
    }

    protected void checkTypeAssignment(@Nullable SqlValidatorScope sourceScope, SqlValidatorTable table, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        List sourceFields = sourceRowType.getFieldList();
        List targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            RelDataType sourceFielRelDataType = ((RelDataTypeField)sourceFields.get(i)).getType();
            RelDataType targetFieldRelDataType = ((RelDataTypeField)targetFields.get(i)).getType();
            ColumnType sourceFieldColumnType = Calcites.getColumnTypeForRelDataType(sourceFielRelDataType);
            ColumnType targetFieldColumnType = Calcites.getColumnTypeForRelDataType(targetFieldRelDataType);
            try {
                if (Objects.equals(targetFieldColumnType, ColumnType.leastRestrictiveType((ColumnType)targetFieldColumnType, (ColumnType)sourceFieldColumnType))) continue;
                throw new Types.IncompatibleTypeException((TypeSignature)targetFieldColumnType, (TypeSignature)sourceFieldColumnType);
            }
            catch (Types.IncompatibleTypeException e) {
                String targetTypeString;
                String sourceTypeString;
                SqlNode node = DruidSqlValidator.getNthExpr(query, i, sourceCount);
                if (SqlTypeUtil.areCharacterSetsMismatched((RelDataType)sourceFielRelDataType, (RelDataType)targetFieldRelDataType)) {
                    sourceTypeString = sourceFielRelDataType.getFullTypeString();
                    targetTypeString = targetFieldRelDataType.getFullTypeString();
                } else {
                    sourceTypeString = sourceFielRelDataType.toString();
                    targetTypeString = targetFieldRelDataType.toString();
                }
                throw this.newValidationError(node, Static.RESOURCE.typeNotAssignable(((RelDataTypeField)targetFields.get(i)).getName(), targetTypeString, ((RelDataTypeField)sourceFields.get(i)).getName(), sourceTypeString));
            }
        }
        super.checkTypeAssignment(sourceScope, table, sourceRowType, targetRowType, query);
    }

    protected RelDataType computeTypeForDefinedCol(DatasourceFacade.ColumnFacade definedCol, RelDataTypeField sourceField) {
        ColumnType columnType;
        SqlTypeName sqlTypeName = SqlTypeName.get((String)definedCol.sqlStorageType());
        RelDataType relType = sqlTypeName != null ? this.typeFactory.createSqlType(sqlTypeName) : ((columnType = ColumnType.fromString((String)definedCol.sqlStorageType())) != null && ((ValueType)columnType.getType()).equals((Object)ValueType.COMPLEX) ? RowSignatures.makeComplexType(this.typeFactory, columnType, sourceField.getType().isNullable()) : RowSignatures.columnTypeToRelDataType(this.typeFactory, columnType, sourceField.getType().isNullable()));
        return relType;
    }

    private static SqlNode getNthExpr(SqlNode query, int ordinal, int sourceCount) {
        if (query instanceof SqlInsert) {
            SqlInsert insert = (SqlInsert)query;
            if (insert.getTargetColumnList() != null) {
                return insert.getTargetColumnList().get(ordinal);
            }
            return DruidSqlValidator.getNthExpr(insert.getSource(), ordinal, sourceCount);
        }
        if (query instanceof SqlUpdate) {
            SqlUpdate update = (SqlUpdate)query;
            if (update.getSourceExpressionList() != null) {
                return update.getSourceExpressionList().get(ordinal);
            }
            return DruidSqlValidator.getNthExpr((SqlNode)SqlNonNullableAccessors.getSourceSelect((SqlUpdate)update), ordinal, sourceCount);
        }
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            SqlNodeList selectList = SqlNonNullableAccessors.getSelectList((SqlSelect)select);
            if (selectList.size() == sourceCount) {
                return selectList.get(ordinal);
            }
            return query;
        }
        return query;
    }

    private boolean isPrecedingOrFollowing(@Nullable SqlNode bound) {
        if (bound == null) {
            return false;
        }
        SqlKind kind = bound.getKind();
        return kind == SqlKind.PRECEDING || kind == SqlKind.FOLLOWING;
    }

    private boolean isValidEndpoint(@Nullable SqlNode bound) {
        SqlNode boundVal;
        if (this.isUnboundedOrCurrent(bound)) {
            return true;
        }
        return (bound.getKind() == SqlKind.FOLLOWING || bound.getKind() == SqlKind.PRECEDING) && SqlUtil.isLiteral((SqlNode)(boundVal = ((SqlCall)bound).operand(0)));
    }

    private boolean isUnboundedOrCurrent(@Nullable SqlNode bound) {
        return bound == null || SqlWindow.isCurrentRow((SqlNode)bound) || SqlWindow.isUnboundedFollowing((SqlNode)bound) || SqlWindow.isUnboundedPreceding((SqlNode)bound);
    }

    private void updateBoundsIfNeeded(SqlWindow window) {
        @Nullable SqlNode lowerBound = window.getLowerBound();
        @Nullable SqlNode upperBound = window.getUpperBound();
        if (lowerBound != null && upperBound == null) {
            if (lowerBound.getKind() == SqlKind.FOLLOWING || SqlWindow.isUnboundedFollowing((SqlNode)lowerBound)) {
                upperBound = lowerBound;
                lowerBound = SqlWindow.createCurrentRow((SqlParserPos)SqlParserPos.ZERO);
            } else {
                upperBound = SqlWindow.createCurrentRow((SqlParserPos)SqlParserPos.ZERO);
            }
            window.setLowerBound(lowerBound);
            window.setUpperBound(upperBound);
        }
    }

    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        SqlNode op0;
        if (call.getKind() == SqlKind.OVER && !this.plannerContext.featureAvailable(EngineFeature.WINDOW_FUNCTIONS)) {
            throw DruidSqlValidator.buildCalciteContextException(StringUtils.format((String)"The query contains window functions; They are not supported on engine[%s].", (Object[])new Object[]{this.plannerContext.getEngine().name()}), (SqlNode)call);
        }
        if (call.getKind() == SqlKind.NULLS_FIRST && (op0 = (SqlNode)call.getOperandList().get(0)).getKind() == SqlKind.DESCENDING) {
            throw DruidSqlValidator.buildCalciteContextException("DESCENDING ordering with NULLS FIRST is not supported!", (SqlNode)call);
        }
        if (call.getKind() == SqlKind.NULLS_LAST && (op0 = (SqlNode)call.getOperandList().get(0)).getKind() != SqlKind.DESCENDING) {
            throw DruidSqlValidator.buildCalciteContextException("ASCENDING ordering with NULLS LAST is not supported!", (SqlNode)call);
        }
        if (this.plannerContext.getPlannerConfig().isUseApproximateCountDistinct() && this.isSqlCallDistinct(call) && call.getOperator().getKind() != SqlKind.COUNT && call.getOperator() instanceof SqlAggFunction && !call.getOperator().getClass().isAnnotationPresent(NativelySupportsDistinct.class)) {
            throw DruidSqlValidator.buildCalciteContextException(StringUtils.format((String)"Aggregation [%s] with DISTINCT is not supported when useApproximateCountDistinct is enabled. Run with disabling it.", (Object[])new Object[]{call.getOperator().getName()}), (SqlNode)call);
        }
        super.validateCall(call, scope);
    }

    protected void validateWindowClause(SqlSelect select) {
        SqlNodeList windows = select.getWindowList();
        for (SqlNode sqlNode : windows) {
            if (SqlUtil.containsAgg((SqlNode)sqlNode)) {
                throw DruidSqlValidator.buildCalciteContextException("Aggregation inside window is currently not supported with syntax WINDOW W AS <DEF>. Try providing window definition directly without alias", sqlNode);
            }
            if (!(sqlNode instanceof SqlWindow)) continue;
            SqlWindow window = (SqlWindow)sqlNode;
            this.updateBoundsIfNeeded(window);
        }
        super.validateWindowClause(select);
    }

    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlNode rewritten;
        if (node != null && (node.getKind() == SqlKind.IN || node.getKind() == SqlKind.NOT_IN) && (rewritten = this.rewriteInToScalarInArrayIfNeeded((SqlCall)node, underFrom)) != node) {
            return rewritten;
        }
        return super.performUnconditionalRewrites(node, underFrom);
    }

    private SqlNode rewriteInToScalarInArrayIfNeeded(SqlCall call, boolean underFrom) {
        if (call.getOperandList().size() == 2 && call.getOperandList().get(1) instanceof SqlNodeList) {
            SqlNode exprNode = (SqlNode)call.getOperandList().get(0);
            SqlNodeList valuesNode = (SqlNodeList)call.getOperandList().get(1);
            if (valuesNode.size() > this.plannerContext.queryContext().getInFunctionThreshold() && valuesNode.stream().allMatch(node -> node.getKind() == SqlKind.LITERAL && !SqlUtil.isNull((SqlNode)node))) {
                SqlCall newCall = ScalarInArrayOperatorConversion.SQL_FUNCTION.createCall(call.getParserPosition(), new SqlNode[]{this.performUnconditionalRewrites(exprNode, underFrom), SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(valuesNode)});
                if (call.getKind() == SqlKind.NOT_IN) {
                    return SqlStdOperatorTable.NOT.createCall(call.getParserPosition(), new SqlNode[]{newCall});
                }
                return newCall;
            }
        }
        return call;
    }

    public static CalciteContextException buildCalciteContextException(String message, SqlNode call) {
        return DruidSqlValidator.buildCalciteContextException((Throwable)new CalciteException(message, null), message, call);
    }

    public static CalciteContextException buildCalciteContextException(Throwable t, String message, SqlNode call) {
        SqlParserPos pos = call.getParserPosition();
        return new CalciteContextException(message, t, pos.getLineNum(), pos.getColumnNum(), pos.getEndLineNum(), pos.getEndColumnNum());
    }

    private SqlNode getSqlNodeFor(SqlInsert insert, int idx) {
        SqlSelect sqlSelect;
        SqlNodeList selectList;
        SqlNode src = insert.getSource();
        if (src instanceof SqlSelect && idx < (selectList = (sqlSelect = (SqlSelect)src).getSelectList()).size()) {
            return selectList.get(idx);
        }
        return src;
    }

    private boolean isSqlCallDistinct(@Nullable SqlCall call) {
        return call != null && call.getFunctionQuantifier() != null && call.getFunctionQuantifier().getValue() == SqlSelectKeyword.DISTINCT;
    }

    protected void validateHavingClause(SqlSelect select) {
        super.validateHavingClause(select);
        SqlNode having = select.getHaving();
        if (this.containsOver(having)) {
            throw DruidSqlValidator.buildCalciteContextException("Window functions are not allowed in HAVING", having);
        }
    }

    private boolean containsOver(SqlNode having) {
        if (having == null) {
            return false;
        }
        Predicate<SqlCall> callPredicate = call -> call.getOperator() instanceof SqlOverOperator;
        return DruidSqlValidator.containsCall(having, callPredicate);
    }

    private static boolean containsCall(SqlNode node, final Predicate<SqlCall> callPredicate) {
        try {
            SqlBasicVisitor<Void> visitor = new SqlBasicVisitor<Void>(){

                public Void visit(SqlCall call) {
                    if (callPredicate.test(call)) {
                        throw new Util.FoundOne((Object)call);
                    }
                    return (Void)super.visit(call);
                }
            };
            node.accept((SqlVisitor)visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow((Throwable)e, null);
            return true;
        }
    }
}

