/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Chars;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class Calcites {
    public static final DateTimes.UtcFormatter CALCITE_DATE_PARSER = DateTimes.wrapFormatter((DateTimeFormatter)ISODateTimeFormat.dateParser());
    public static final DateTimes.UtcFormatter CALCITE_TIMESTAMP_PARSER = DateTimes.wrapFormatter((DateTimeFormatter)new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateParser()).appendLiteral(' ').append(ISODateTimeFormat.timeParser()).toFormatter());
    private static final DateTimeFormatter CALCITE_TIME_PRINTER = DateTimeFormat.forPattern((String)"HH:mm:ss.S");
    private static final DateTimeFormatter CALCITE_DATE_PRINTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter CALCITE_TIMESTAMP_PRINTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private static final Charset DEFAULT_CHARSET = Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
    private static final Pattern TRAILING_ZEROS = Pattern.compile("\\.?0+$");
    public static final SqlReturnTypeInference ARG0_NULLABLE_ARRAY_RETURN_TYPE_INFERENCE = new Arg0NullableArrayTypeInference();
    public static final SqlReturnTypeInference ARG1_NULLABLE_ARRAY_RETURN_TYPE_INFERENCE = new Arg1NullableArrayTypeInference();

    public static SqlReturnTypeInference complexReturnTypeWithNullability(ColumnType columnType, boolean nullable) {
        return opBinding -> RowSignatures.makeComplexType(opBinding.getTypeFactory(), columnType, nullable);
    }

    private Calcites() {
    }

    public static Charset defaultCharset() {
        return DEFAULT_CHARSET;
    }

    public static String escapeStringLiteral(String s) {
        Preconditions.checkNotNull((Object)s);
        boolean isPlainAscii = true;
        StringBuilder builder = new StringBuilder("'");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c >= ' ' && c < '\u007f' && c != '\'' && c != '\\') {
                builder.append(c);
                if (c <= '\u007f') continue;
                isPlainAscii = false;
                continue;
            }
            builder.append("\\").append(BaseEncoding.base16().encode(Chars.toByteArray((char)c)));
            isPlainAscii = false;
        }
        builder.append("'");
        return isPlainAscii ? builder.toString() : "U&" + String.valueOf(builder);
    }

    public static boolean isLiteral(RexNode rexNode, boolean allowCast, boolean allowArray) {
        if (RexUtil.isLiteral((RexNode)rexNode, (boolean)allowCast)) {
            return true;
        }
        if (allowArray && rexNode.isA(SqlKind.ARRAY_VALUE_CONSTRUCTOR)) {
            for (RexNode element : ((RexCall)rexNode).getOperands()) {
                if (RexUtil.isLiteral((RexNode)element, (boolean)allowCast)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static ColumnType getColumnTypeForRelDataType(RelDataType type) {
        ColumnType valueType = Calcites.getValueTypeForRelDataTypeFull(type);
        if (ExpressionProcessing.processArraysAsMultiValueStrings() && valueType != null && valueType.isArray()) {
            return ColumnType.STRING;
        }
        return valueType;
    }

    @Nullable
    public static ColumnType getValueTypeForRelDataTypeFull(RelDataType type) {
        SqlTypeName sqlTypeName = type.getSqlTypeName();
        if (SqlTypeName.FLOAT == sqlTypeName) {
            return ColumnType.FLOAT;
        }
        if (Calcites.isDoubleType(sqlTypeName)) {
            return ColumnType.DOUBLE;
        }
        if (Calcites.isLongType(sqlTypeName)) {
            return ColumnType.LONG;
        }
        if (Calcites.isStringType(sqlTypeName) || sqlTypeName == SqlTypeName.NULL) {
            return ColumnType.STRING;
        }
        if (SqlTypeName.OTHER == sqlTypeName) {
            if (type instanceof RowSignatures.ComplexSqlType) {
                return ColumnType.ofComplex((String)((RowSignatures.ComplexSqlType)type).getComplexTypeName());
            }
            return ColumnType.UNKNOWN_COMPLEX;
        }
        if (sqlTypeName == SqlTypeName.ARRAY) {
            ColumnType elementType = Calcites.getValueTypeForRelDataTypeFull(type.getComponentType());
            if (elementType != null) {
                return ColumnType.ofArray((ColumnType)elementType);
            }
            if (type.getComponentType().getSqlTypeName() == SqlTypeName.NULL) {
                return ColumnType.LONG_ARRAY;
            }
            return null;
        }
        return null;
    }

    public static boolean isStringType(SqlTypeName sqlTypeName) {
        return SqlTypeName.CHAR_TYPES.contains(sqlTypeName) || SqlTypeName.INTERVAL_TYPES.contains(sqlTypeName);
    }

    public static boolean isDoubleType(SqlTypeName sqlTypeName) {
        return SqlTypeName.FRACTIONAL_TYPES.contains(sqlTypeName) || SqlTypeName.APPROX_TYPES.contains(sqlTypeName);
    }

    public static boolean isLongType(SqlTypeName sqlTypeName) {
        return SqlTypeName.TIMESTAMP == sqlTypeName || SqlTypeName.DATE == sqlTypeName || SqlTypeName.BOOLEAN == sqlTypeName || SqlTypeName.INT_TYPES.contains(sqlTypeName);
    }

    @Nullable
    public static StringComparator getStringComparatorForRelDataType(RelDataType dataType) {
        if (dataType.getSqlTypeName() == SqlTypeName.NULL) {
            return StringComparators.NATURAL;
        }
        ColumnType valueType = Calcites.getColumnTypeForRelDataType(dataType);
        if (valueType == null) {
            return null;
        }
        return Calcites.getStringComparatorForValueType(valueType);
    }

    public static StringComparator getStringComparatorForValueType(ColumnType valueType) {
        if (valueType.isNumeric()) {
            return StringComparators.NUMERIC;
        }
        if (valueType.is((TypeDescriptor)ValueType.STRING)) {
            return StringComparators.LEXICOGRAPHIC;
        }
        return StringComparators.NATURAL;
    }

    public static RelDataType createSqlType(RelDataTypeFactory typeFactory, SqlTypeName typeName) {
        return Calcites.createSqlTypeWithNullability(typeFactory, typeName, false);
    }

    public static RelDataType createSqlTypeWithNullability(RelDataTypeFactory typeFactory, SqlTypeName typeName, boolean nullable) {
        RelDataType dataType;
        switch (typeName) {
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                dataType = typeFactory.createSqlType(typeName, 3);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                dataType = typeFactory.createTypeWithCharsetAndCollation(typeFactory.createSqlType(typeName), Calcites.defaultCharset(), SqlCollation.IMPLICIT);
                break;
            }
            default: {
                dataType = typeFactory.createSqlType(typeName);
            }
        }
        return typeFactory.createTypeWithNullability(dataType, nullable);
    }

    public static RelDataType createSqlArrayTypeWithNullability(RelDataTypeFactory typeFactory, SqlTypeName elementTypeName, boolean nullable) {
        RelDataType dataType = typeFactory.createTypeWithNullability(typeFactory.createArrayType(Calcites.createSqlTypeWithNullability(typeFactory, elementTypeName, nullable), -1L), true);
        return dataType;
    }

    public static long jodaToCalciteTimestamp(DateTime dateTime, DateTimeZone timeZone) {
        return dateTime.withZone(timeZone).withZoneRetainFields(DateTimeZone.UTC).getMillis();
    }

    public static int jodaToCalciteDate(DateTime dateTime, DateTimeZone timeZone) {
        DateTime date = dateTime.withZone(timeZone).dayOfMonth().roundFloorCopy();
        return Days.daysBetween((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)date.withZoneRetainFields(DateTimeZone.UTC)).getDays();
    }

    public static RexLiteral jodaToCalciteTimestampLiteral(RexBuilder rexBuilder, DateTime dateTime, DateTimeZone sessionTimeZone, int precision) {
        return rexBuilder.makeTimestampLiteral(Calcites.jodaToCalciteTimestampString(dateTime, sessionTimeZone), precision);
    }

    public static TimestampString jodaToCalciteTimestampString(DateTime dateTime, DateTimeZone sessionTimeZone) {
        String timestampString = TRAILING_ZEROS.matcher(CALCITE_TIMESTAMP_PRINTER.print((ReadableInstant)dateTime.withZone(sessionTimeZone))).replaceAll("");
        return new TimestampString(timestampString);
    }

    public static TimeString jodaToCalciteTimeString(DateTime dateTime, DateTimeZone timeZone) {
        String timeString = TRAILING_ZEROS.matcher(CALCITE_TIME_PRINTER.print((ReadableInstant)dateTime.withZone(timeZone))).replaceAll("");
        return new TimeString(timeString);
    }

    public static DateString jodaToCalciteDateString(DateTime dateTime, DateTimeZone timeZone) {
        return new DateString(CALCITE_DATE_PRINTER.print((ReadableInstant)dateTime.withZone(timeZone)));
    }

    public static DateTime calciteDateTimeLiteralToJoda(RexNode literal, DateTimeZone timeZone) {
        SqlTypeName typeName = literal.getType().getSqlTypeName();
        if (literal.getKind() != SqlKind.LITERAL) {
            throw DruidException.defensive((String)"Expected literal but got[%s]", (Object[])new Object[]{literal.getKind()});
        }
        if (typeName == SqlTypeName.TIMESTAMP) {
            TimestampString timestampString = (TimestampString)RexLiteral.value((RexNode)literal);
            return CALCITE_TIMESTAMP_PARSER.parse(timestampString.toString()).withZoneRetainFields(timeZone);
        }
        if (typeName == SqlTypeName.DATE) {
            DateString dateString = (DateString)RexLiteral.value((RexNode)literal);
            return CALCITE_DATE_PARSER.parse(dateString.toString()).withZoneRetainFields(timeZone);
        }
        throw DruidException.defensive((String)"Expected TIMESTAMP or DATE but got[%s]", (Object[])new Object[]{typeName});
    }

    public static DateTime calciteTimestampToJoda(long timestamp, DateTimeZone timeZone) {
        return new DateTime(timestamp, DateTimeZone.UTC).withZoneRetainFields(timeZone);
    }

    public static DateTime calciteDateToJoda(int date, DateTimeZone timeZone) {
        return DateTimes.EPOCH.plusDays(date).withZoneRetainFields(timeZone);
    }

    public static String findUnusedPrefixForDigits(String basePrefix, Iterable<String> strings) {
        TreeSet<String> navigableStrings;
        if (strings instanceof NavigableSet) {
            navigableStrings = (TreeSet<String>)strings;
        } else {
            navigableStrings = new TreeSet<String>();
            Iterables.addAll(navigableStrings, strings);
        }
        Object prefix = basePrefix;
        while (!Calcites.isUnusedPrefix((String)prefix, navigableStrings)) {
            prefix = "_" + (String)prefix;
        }
        return prefix;
    }

    private static boolean isUnusedPrefix(String prefix, NavigableSet<String> strings) {
        NavigableSet<String> subSet = strings.subSet(prefix + "0", true, prefix + ":", false);
        return subSet.isEmpty();
    }

    public static String makePrefixedName(String prefix, String suffix) {
        return StringUtils.format((String)"%s:%s", (Object[])new Object[]{prefix, suffix});
    }

    public static Class<?> sqlTypeNameJdbcToJavaClass(SqlTypeName typeName) {
        JDBCType jdbcType = JDBCType.valueOf(typeName.getJdbcOrdinal());
        switch (jdbcType) {
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                return String.class;
            }
            case NUMERIC: 
            case DECIMAL: {
                return BigDecimal.class;
            }
            case BIT: {
                return Boolean.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case BIGINT: {
                return Long.class;
            }
            case REAL: {
                return Float.class;
            }
            case FLOAT: 
            case DOUBLE: {
                return Double.class;
            }
            case BINARY: 
            case VARBINARY: {
                return Byte[].class;
            }
            case DATE: {
                return Date.class;
            }
            case TIME: {
                return Time.class;
            }
            case TIMESTAMP: {
                return Timestamp.class;
            }
        }
        return Object.class;
    }

    public static class Arg0NullableArrayTypeInference
    implements SqlReturnTypeInference {
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType type = opBinding.getOperandType(0);
            if (SqlTypeUtil.isArray((RelDataType)type)) {
                return type;
            }
            return Calcites.createSqlArrayTypeWithNullability(opBinding.getTypeFactory(), type.getSqlTypeName(), true);
        }
    }

    public static class Arg1NullableArrayTypeInference
    implements SqlReturnTypeInference {
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType type = opBinding.getOperandType(1);
            if (SqlTypeUtil.isArray((RelDataType)type)) {
                return type;
            }
            return Calcites.createSqlArrayTypeWithNullability(opBinding.getTypeFactory(), type.getSqlTypeName(), true);
        }
    }
}

