/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class RegexpLikeOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("REGEXP_LIKE").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).requiredOperandCount(2).literalOperands(1).returnTypeCascadeNullable(SqlTypeName.BOOLEAN).functionCategory(SqlFunctionCategory.STRING).build();

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertDirectCall(plannerContext, rowSignature, rexNode, "regexp_like");
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        List operands = ((RexCall)rexNode).getOperands();
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)operands.get(0));
        if (druidExpression == null) {
            return null;
        }
        String pattern = RexLiteral.stringValue((RexNode)((RexNode)operands.get(1)));
        if (druidExpression.isSimpleExtraction()) {
            return new RegexDimFilter(druidExpression.getSimpleExtraction().getColumn(), pattern, druidExpression.getSimpleExtraction().getExtractionFn(), null);
        }
        if (virtualColumnRegistry != null) {
            String v = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(druidExpression, ((RexNode)operands.get(0)).getType());
            return new RegexDimFilter(v, pattern, null, null);
        }
        return null;
    }
}

