/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class HumanReadableFormatOperatorConversion
implements SqlOperatorConversion {
    public static final SqlOperatorConversion BINARY_BYTE_FORMAT = new HumanReadableFormatOperatorConversion("human_readable_binary_byte_format");
    public static final SqlOperatorConversion DECIMAL_BYTE_FORMAT = new HumanReadableFormatOperatorConversion("human_readable_decimal_byte_format");
    public static final SqlOperatorConversion DECIMAL_FORMAT = new HumanReadableFormatOperatorConversion("human_readable_decimal_format");
    private final String name;
    private final SqlFunction sqlFunction;

    private HumanReadableFormatOperatorConversion(String name) {
        this.sqlFunction = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)name)).operandTypeChecker(new HumanReadableFormatOperandTypeChecker()).functionCategory(SqlFunctionCategory.STRING).returnTypeCascadeNullable(SqlTypeName.VARCHAR).build();
        this.name = name;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.sqlFunction;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertDirectCall(plannerContext, rowSignature, rexNode, this.name);
    }

    private static class HumanReadableFormatOperandTypeChecker
    implements SqlOperandTypeChecker {
        private HumanReadableFormatOperandTypeChecker() {
        }

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            RelDataType secondArgType;
            boolean isSigatureError = false;
            RelDataType firstArgType = callBinding.getOperandType(0);
            if (!SqlTypeName.NUMERIC_TYPES.contains(firstArgType.getSqlTypeName())) {
                isSigatureError = true;
            }
            if (callBinding.getOperandCount() > 1 && !SqlTypeName.NUMERIC_TYPES.contains((secondArgType = callBinding.getOperandType(1)).getSqlTypeName())) {
                isSigatureError = true;
            }
            if (isSigatureError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return isSigatureError;
        }

        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.between((int)1, (int)2);
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return StringUtils.format((String)"%s(Number, [Precision])", (Object[])new Object[]{opName});
        }

        public SqlOperandTypeChecker.Consistency getConsistency() {
            return SqlOperandTypeChecker.Consistency.NONE;
        }

        public boolean isOptional(int i) {
            return i > 0;
        }
    }
}

