/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class CoalesceOperatorConversion
implements SqlOperatorConversion {
    private final SqlFunction function;

    public CoalesceOperatorConversion(SqlFunction function) {
        this.function = function;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.function;
    }

    @Override
    @Nullable
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertDirectCall(plannerContext, rowSignature, rexNode, CoalesceOperatorConversion.getNativeFunctionName(rexNode));
    }

    @Override
    @Nullable
    public DruidExpression toDruidExpressionWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
        return OperatorConversions.convertCallWithPostAggOperands(plannerContext, rowSignature, rexNode, operands -> DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), CoalesceOperatorConversion.getNativeFunctionName(rexNode), operands), postAggregatorVisitor);
    }

    private static String getNativeFunctionName(RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        return call.getOperands().size() == 2 ? "nvl" : "coalesce";
    }
}

