/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.CastedLiteralOperandTypeChecker;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.Static;
import org.apache.druid.error.DruidException;

public class CastedLiteralOperandTypeCheckers {
    public static final SqlSingleOperandTypeChecker LITERAL = new CastedLiteralOperandTypeChecker(false);
    public static final SqlSingleOperandTypeChecker POSITIVE_INTEGER_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER), i -> false){

        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, SqlTypeFamily family, boolean throwOnFailure) {
            if (!LITERAL.checkSingleOperandType(callBinding, operand, iFormalOperand, throwOnFailure)) {
                return false;
            }
            if (!super.checkSingleOperandType(callBinding, operand, iFormalOperand, family, throwOnFailure)) {
                return false;
            }
            SqlLiteral arg = CastedLiteralOperandTypeCheckers.fetchPrimitiveLiteralFromCasts(operand);
            BigDecimal value = (BigDecimal)arg.getValueAs(BigDecimal.class);
            if (value.compareTo(BigDecimal.ZERO) < 0 || this.hasFractionalPart(value)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.argumentMustBePositiveInteger(callBinding.getOperator().getName()));
                }
                return false;
            }
            if (value.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.numberLiteralOutOfRange(value.toString()));
                }
                return false;
            }
            return true;
        }

        private boolean hasFractionalPart(BigDecimal bd) {
            return bd.precision() - bd.scale() <= 0;
        }
    };

    private static SqlLiteral fetchPrimitiveLiteralFromCasts(SqlNode node) {
        if (node == null) {
            throw DruidException.defensive((String)"'node' cannot be null", (Object[])new Object[0]);
        }
        if (node instanceof SqlLiteral) {
            return (SqlLiteral)node;
        }
        switch (node.getKind()) {
            case CAST: {
                return CastedLiteralOperandTypeCheckers.fetchPrimitiveLiteralFromCasts(((SqlCall)node).operand(0));
            }
            case DEFAULT: {
                return SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
            }
        }
        throw DruidException.defensive((String)"Expected a literal or a cast on the literal. Found [%s] instead", (Object[])new Object[]{node.getKind()});
    }
}

