/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.workqueue;

import io.kubernetes.client.extended.workqueue.DefaultWorkQueue;
import io.kubernetes.client.extended.workqueue.DelayingQueue;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class DefaultDelayingQueue<T>
extends DefaultWorkQueue<T>
implements DelayingQueue<T> {
    public static Duration heartBeatInterval = Duration.ofSeconds(10L);
    private DelayQueue<WaitForEntry<T>> delayQueue;
    private ConcurrentMap<T, WaitForEntry<T>> waitingEntryByData;
    protected BlockingQueue<WaitForEntry<T>> waitingForAddQueue;
    private Supplier<Long> timeSource = DefaultDelayingQueue::now;

    private static Long now() {
        return System.nanoTime() / 1000000L;
    }

    public DefaultDelayingQueue(ExecutorService waitingWorker) {
        this.delayQueue = new DelayQueue();
        this.waitingEntryByData = new ConcurrentHashMap<T, WaitForEntry<T>>();
        this.waitingForAddQueue = new LinkedBlockingQueue<WaitForEntry<T>>(1000);
        waitingWorker.submit(this::waitingLoop);
    }

    public DefaultDelayingQueue() {
        this(Executors.newSingleThreadExecutor());
    }

    @Override
    public void addAfter(T item, Duration duration) {
        if (super.isShuttingDown()) {
            return;
        }
        if (duration.isZero()) {
            super.add(item);
            return;
        }
        WaitForEntry entry = new WaitForEntry(item, this.timeSource.get() + duration.toMillis(), this.timeSource);
        this.waitingForAddQueue.offer(entry);
    }

    protected void injectTimeSource(Supplier<Long> fn) {
        this.timeSource = fn;
    }

    private void waitingLoop() {
        try {
            while (true) {
                WaitForEntry<T> waitForEntry;
                if (super.isShuttingDown()) {
                    return;
                }
                WaitForEntry entry = (WaitForEntry)this.delayQueue.peek();
                Duration nextReadyAt = heartBeatInterval;
                if (entry != null) {
                    long now = this.timeSource.get();
                    if (now - entry.readyAtMillis >= 0L) {
                        this.delayQueue.remove(entry);
                        super.add(entry.data);
                        this.waitingEntryByData.remove(entry.data);
                        continue;
                    }
                    nextReadyAt = Duration.ofMillis(entry.readyAtMillis - now);
                }
                if ((waitForEntry = this.waitingForAddQueue.poll(nextReadyAt.toMillis(), TimeUnit.MILLISECONDS)) == null) continue;
                if (this.timeSource.get() - ((WaitForEntry)waitForEntry).readyAtMillis < 0L) {
                    this.insert(this.delayQueue, this.waitingEntryByData, waitForEntry);
                    continue;
                }
                super.add(((WaitForEntry)waitForEntry).data);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void insert(DelayQueue<WaitForEntry<T>> q, Map<T, WaitForEntry<T>> knownEntries, WaitForEntry entry) {
        WaitForEntry<T> existing = knownEntries.get(entry.data);
        if (existing != null) {
            if (entry.readyAtMillis - ((WaitForEntry)existing).readyAtMillis < 0L) {
                q.remove(existing);
                ((WaitForEntry)existing).readyAtMillis = entry.readyAtMillis;
                q.add(existing);
            }
            return;
        }
        q.offer(entry);
        knownEntries.put(entry.data, entry);
    }

    private static class WaitForEntry<T>
    implements Delayed {
        private T data;
        private long readyAtMillis;
        private Supplier<Long> timeSource;

        private WaitForEntry(T data, long readyAtMillis, Supplier<Long> timeSource) {
            this.data = data;
            this.readyAtMillis = readyAtMillis;
            this.timeSource = timeSource;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long duration = this.readyAtMillis - this.timeSource.get();
            return unit.convert(duration, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }
    }
}

