/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.view;

import jakarta.faces.application.ViewHandler;
import jakarta.faces.application.ViewHandlerWrapper;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.jsf.impl.security.SecurityAwareViewHandler;

public class DeltaSpikeViewHandler
extends ViewHandlerWrapper
implements Deactivatable {
    protected final ViewHandler wrapped;
    private volatile Boolean initialized;
    private ViewHandler securityAwareViewHandler;

    public DeltaSpikeViewHandler(ViewHandler wrapped) {
        this.wrapped = wrapped;
    }

    protected ViewHandler createSecurityAwareViewHandler() {
        return new SecurityAwareViewHandler(this.wrapped);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        this.lazyInit();
        if (this.securityAwareViewHandler == null) {
            return this.wrapped.createView(facesContext, viewId);
        }
        return this.securityAwareViewHandler.createView(facesContext, viewId);
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized == null) {
            this.securityAwareViewHandler = ClassDeactivationUtils.isActivated(((Object)((Object)this)).getClass()) ? this.createSecurityAwareViewHandler() : null;
            this.initialized = true;
        }
    }
}

