/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.mergepoint;

import java.util.ArrayList;
import java.util.List;
import org.apache.torque.generator.control.action.MergepointAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergepointMapping {
    private String name;
    private List<MergepointAction> actions = new ArrayList<MergepointAction>();

    public MergepointMapping(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
    }

    public MergepointMapping(String name, List<MergepointAction> actions) {
        this(name);
        this.actions.addAll(actions);
    }

    public String getName() {
        return this.name;
    }

    public List<MergepointAction> getActions() {
        return this.actions;
    }

    public void addAction(MergepointAction action) {
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        this.actions.add(action);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(name=").append(this.name).append(",actions=").append(this.actions).append(")");
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : ((Object)this.actions).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergepointMapping other = (MergepointMapping)obj;
        if (this.actions == null ? other.actions != null : !((Object)this.actions).equals(other.actions)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

