/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.AbstractCoupons;
import org.apache.datasketches.hll.CouponHashSet;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.IntArrayPairIterator;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

class CouponList
extends AbstractCoupons {
    int lgCouponArrInts;
    int couponCount;
    int[] couponIntArr;

    private static int checkLgConfigK(CurMode curMode, int lgConfigK) {
        if (curMode == CurMode.SET) assert (lgConfigK > 7);
        return lgConfigK;
    }

    CouponList(int lgConfigK, TgtHllType tgtHllType, CurMode curMode) {
        super(CouponList.checkLgConfigK(curMode, lgConfigK), tgtHllType, curMode);
        this.lgCouponArrInts = curMode == CurMode.LIST ? 3 : 5;
        this.couponIntArr = new int[1 << this.lgCouponArrInts];
        this.couponCount = 0;
    }

    CouponList(CouponList that) {
        super(that.lgConfigK, that.tgtHllType, that.curMode);
        this.lgCouponArrInts = that.lgCouponArrInts;
        this.couponCount = that.couponCount;
        this.couponIntArr = (int[])that.couponIntArr.clone();
    }

    CouponList(CouponList that, TgtHllType tgtHllType) {
        super(that.lgConfigK, tgtHllType, that.curMode);
        this.lgCouponArrInts = that.lgCouponArrInts;
        this.couponCount = that.couponCount;
        this.couponIntArr = (int[])that.couponIntArr.clone();
    }

    static final CouponList heapifyList(MemorySegment seg) {
        int lgConfigK = PreambleUtil.extractLgK(seg);
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(seg);
        CouponList list = new CouponList(lgConfigK, tgtHllType, CurMode.LIST);
        int couponCount = PreambleUtil.extractListCount(seg);
        MemorySegment.copy(seg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.LIST_INT_ARR_START, list.couponIntArr, 0, couponCount);
        list.couponCount = couponCount;
        return list;
    }

    @Override
    CouponList copy() {
        return new CouponList(this);
    }

    @Override
    CouponList copyAs(TgtHllType tgtHllType) {
        return new CouponList(this, tgtHllType);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int len = 1 << this.lgCouponArrInts;
        for (int i = 0; i < len; ++i) {
            int couponAtIdx = this.couponIntArr[i];
            if (couponAtIdx == 0) {
                this.couponIntArr[i] = coupon;
                ++this.couponCount;
                if (this.couponCount >= len) {
                    if (this.lgConfigK < 8) {
                        return CouponList.promoteHeapListOrSetToHll(this);
                    }
                    return CouponList.promoteHeapListToSet(this);
                }
                return this;
            }
            if (couponAtIdx != coupon) continue;
            return this;
        }
        throw new SketchesStateException("Array invalid: no empties & no duplicates");
    }

    @Override
    int getCompactSerializationBytes() {
        return this.getSegDataStart() + (this.couponCount << 2);
    }

    @Override
    int getCouponCount() {
        return this.couponCount;
    }

    @Override
    int[] getCouponIntArr() {
        return this.couponIntArr;
    }

    @Override
    int getLgCouponArrInts() {
        return this.lgCouponArrInts;
    }

    @Override
    int getSegDataStart() {
        return PreambleUtil.LIST_INT_ARR_START;
    }

    @Override
    MemorySegment getMemorySegment() {
        return null;
    }

    @Override
    int getPreInts() {
        return 2;
    }

    @Override
    boolean isCompact() {
        return false;
    }

    @Override
    boolean hasMemorySegment() {
        return false;
    }

    @Override
    boolean isOffHeap() {
        return false;
    }

    @Override
    boolean isSameResource(MemorySegment seg) {
        return false;
    }

    @Override
    PairIterator iterator() {
        return new IntArrayPairIterator(this.couponIntArr, this.lgConfigK);
    }

    @Override
    void mergeTo(HllSketch that) {
        for (int pair : this.couponIntArr) {
            if (pair == 0) continue;
            that.couponUpdate(pair);
        }
    }

    @Override
    CouponList reset() {
        return new CouponList(this.lgConfigK, this.tgtHllType, CurMode.LIST);
    }

    static final HllSketchImpl promoteHeapListToSet(CouponList list) {
        int couponCount = list.couponCount;
        int[] arr = list.couponIntArr;
        CouponHashSet chSet = new CouponHashSet(list.lgConfigK, list.tgtHllType);
        for (int i = 0; i < couponCount; ++i) {
            chSet.couponUpdate(arr[i]);
        }
        return chSet;
    }

    static final HllSketchImpl promoteHeapListOrSetToHll(CouponList src) {
        HllArray tgtHllArr = HllArray.newHeapHll(src.lgConfigK, src.tgtHllType);
        PairIterator srcItr = src.iterator();
        tgtHllArr.putKxQ0(1 << src.lgConfigK);
        while (srcItr.nextValid()) {
            tgtHllArr.couponUpdate(srcItr.getPair());
        }
        tgtHllArr.putHipAccum(src.getEstimate());
        tgtHllArr.putOutOfOrder(false);
        return tgtHllArr;
    }
}

