/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.thetacommon.SetOperationCornerCases;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.Util;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MiscTest {
    @Test
    public void checkUpdatableSketchBuilderReset() {
        DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;
        UpdatableTupleSketchBuilder bldr = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(mode));
        bldr.reset();
        UpdatableTupleSketch sk = bldr.build();
        Assert.assertTrue((boolean)sk.isEmpty());
    }

    @Test
    public void checkStringToByteArray() {
        Util.stringToByteArray((String)"");
    }

    @Test
    public void checkDoubleToLongArray() {
        long[] v = Util.doubleToLongArray((double)-0.0);
        Assert.assertEquals((long)v[0], (long)0L);
    }

    public void checkById() {
        int[] ids = new int[]{0, 1, 2, 5, 6};
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                int id = ids[i] << 3 | ids[j];
                SetOperationCornerCases.CornerCase cCase = SetOperationCornerCases.CornerCase.caseIdToCornerCase((int)id);
                String interResStr = cCase.getIntersectAction().getActionDescription();
                String anotbResStr = cCase.getAnotbAction().getActionDescription();
                MiscTest.println(Integer.toOctalString(id) + "\t" + String.valueOf(cCase) + "\t" + cCase.getCaseDescription() + "\t" + interResStr + "\t" + anotbResStr);
            }
        }
    }

    @Test
    public void checkCopyCtor() {
        DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;
        UpdatableTupleSketchBuilder bldr = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(mode));
        bldr.reset();
        UpdatableTupleSketch sk = bldr.build();
        sk.update(1.0, (Object)1.0);
        Assert.assertEquals((int)sk.getRetainedEntries(), (int)1);
        UpdatableTupleSketch sk2 = sk.copy();
        Assert.assertEquals((int)sk2.getRetainedEntries(), (int)1);
    }

    private static void println(Object o) {
    }
}

